#include "cps.h"

#define CPS1_68K_PROGRAM_BYTESWAP	1
#define CPS1_68K_PROGRAM_NO_BYTESWAP	2
#define CPS1_Z80_PROGRAM		3
#define CPS1_TILES			4
#define CPS1_OKIM6295_SAMPLES		5
#define CPS1_QSOUND_SAMPLES		6
#define CPS1_PIC			7

//#define INCLUDE_DUPLICATES		1
#define INCLUDE_CPS1_PHOENIX		1

static unsigned char ForgottnAltGfx;

// Input Definitions

static struct BurnInputInfo NTFOInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(NTFO)

static struct BurnInputInfo ThreeWondersInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Button 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Button 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Button 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Button 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(ThreeWonders)

static struct BurnInputInfo CaptcommInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"P4 Coin"          , BIT_DIGITAL  , CpsInp179+6, "p4 coin"   },
	{"P4 Start"         , BIT_DIGITAL  , CpsInp179+7, "p4 start"  },
	{"P4 Up"            , BIT_DIGITAL  , CpsInp179+3, "p4 up"     },
	{"P4 Down"          , BIT_DIGITAL  , CpsInp179+2, "p4 down"   },
	{"P4 Left"          , BIT_DIGITAL  , CpsInp179+1, "p4 left"   },
	{"P4 Right"         , BIT_DIGITAL  , CpsInp179+0, "p4 right"  },
	{"P4 Attack"        , BIT_DIGITAL  , CpsInp179+4, "p4 fire 1" },
	{"P4 Jump"          , BIT_DIGITAL  , CpsInp179+5, "p4 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Captcomm)

static struct BurnInputInfo CawingInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Cawing)

static struct BurnInputInfo CawingbInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp008+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp008+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp008+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp008+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp008+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp008+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Cawingb)

static struct BurnInputInfo Cworld2jInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Answer 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Answer 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Answer 3"      , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Answer 4"      , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Answer 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Answer 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Answer 3"      , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Answer 4"      , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Cworld2j)

static struct BurnInputInfo DinoInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0 , "p1 coin"  },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4 , "p1 start" },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3 , "p1 up"    },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2 , "p1 down"  },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1 , "p1 left"  },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0 , "p1 right" },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4 , "p1 fire 1"},
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5 , "p1 fire 2"},

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1 , "p2 coin"  },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5 , "p2 start" },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3 , "p2 up"    },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2 , "p2 down"  },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1 , "p2 left"  },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0 , "p2 right" },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4 , "p2 fire 1"},
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5 , "p2 fire 2"},

	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc001+6, "p3 coin"  },
	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" },
	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    },
	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  },
	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  },
	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 1"},
	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 2"},

	{"Reset"            , BIT_DIGITAL  , &CpsReset   ,  "reset"   },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6 ,  "diag"    },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2 ,  "service" },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E     ,  "dip"     },
};

STDINPUTINFO(Dino)

static struct BurnInputInfo DinohInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0 , "p1 coin"  },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4 , "p1 start" },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3 , "p1 up"    },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2 , "p1 down"  },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1 , "p1 left"  },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0 , "p1 right" },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4 , "p1 fire 1"},
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5 , "p1 fire 2"},
	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+6 , "p1 fire 3"},

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1 , "p2 coin"  },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5 , "p2 start" },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3 , "p2 up"    },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2 , "p2 down"  },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1 , "p2 left"  },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0 , "p2 right" },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4 , "p2 fire 1"},
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5 , "p2 fire 2"},
	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+6 , "p2 fire 3"},

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset   ,  "reset"   },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6 ,  "diag"    },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2 ,  "service" },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E     ,  "dip"     },
};

STDINPUTINFO(Dinoh)

static struct BurnInputInfo DynwarInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack 1"  			, BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Attack 2"  		, BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack 1"   		, BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Attack 2"  		, BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Dynwar)

static struct BurnInputInfo FfightInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Ffight)

#define A(a, b, c, d) {a, b, (unsigned char*)(c), d}

static struct BurnInputInfo ForgottnInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL,    CpsInp018+0, "p1 coin"  },
	{"P1 Start"         , BIT_DIGITAL,    CpsInp018+4, "p1 start" },
	{"P1 Up"            , BIT_DIGITAL,    CpsInp001+3, "p1 up"    },
	{"P1 Down"          , BIT_DIGITAL,    CpsInp001+2, "p1 down"  },
	{"P1 Left"          , BIT_DIGITAL,    CpsInp001+1, "p1 left"  },
	{"P1 Right"         , BIT_DIGITAL,    CpsInp001+0, "p1 right" },
	{"P1 Attack"        , BIT_DIGITAL,    CpsInp001+4, "p1 fire 1"},
	A("P1 Turn"         , BIT_ANALOG_REL, &CpsInp055,  "p1 z-axis"),

	{"P2 Coin"          , BIT_DIGITAL,    CpsInp018+1, "p2 coin"  },
	{"P2 Start"         , BIT_DIGITAL,    CpsInp018+5, "p2 start" },
	{"P2 Up"            , BIT_DIGITAL,    CpsInp000+3, "p2 up"    },
	{"P2 Down"          , BIT_DIGITAL,    CpsInp000+2, "p2 down"  },
	{"P2 Left"          , BIT_DIGITAL,    CpsInp000+1, "p2 left"  },
	{"P2 Right"         , BIT_DIGITAL,    CpsInp000+0, "p2 right" },
	{"P2 Attack"        , BIT_DIGITAL,    CpsInp000+4, "p2 fire 1"},
	A("P2 Turn"         , BIT_ANALOG_REL, &CpsInp05d,  "p2 z-axis"),

	{"Reset"            , BIT_DIGITAL,    &CpsReset,   "reset"    },
	{"Service"          , BIT_DIGITAL,    CpsInp018+2, "service"  },

	{"Dip A"            , BIT_DIPSWITCH,  &Cpi01A    , "dip"      },
	{"Dip B"            , BIT_DIPSWITCH,  &Cpi01C    , "dip"      },
	{"Dip C"            , BIT_DIPSWITCH,  &Cpi01E    , "dip"      },
};

#undef A

STDINPUTINFO(Forgottn)

static struct BurnInputInfo GhoulsInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Fire"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	
	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Fire"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Ghouls)

static struct BurnInputInfo KnightsInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Knights)

static struct BurnInputInfo KodInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Kod)

static struct BurnInputInfo KodhInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc000+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInpc000+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInpc000+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInpc000+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInpc000+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInpc000+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc000+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc000+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Kodh)

static struct BurnInputInfo MegamanInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Fire"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Select"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Fire"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Select"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Megaman)

static struct BurnInputInfo MercsInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
	{"P3 Shot"          , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
	{"P3 Special"       , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Mercs)

static struct BurnInputInfo MswordInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Msword)

static struct BurnInputInfo MtwinsInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Mtwins)

static struct BurnInputInfo NemoInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Nemo)

static struct BurnInputInfo Pang3InputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot 1"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Shot 2"        , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot 1"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Shot 2"        , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Pang3)

static struct BurnInputInfo PnickjInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Turn 1"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Turn 2"        , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Turn 1"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Turn 2"        , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Pnickj)

static struct BurnInputInfo PunisherInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Punisher)

static struct BurnInputInfo QadInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Answer 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Answer 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Answer 3"      , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Answer 4"      , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Answer 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Answer 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Answer 3"      , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Answer 4"      , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },
	
	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Qad)

static struct BurnInputInfo Qtono2InputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Answer 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Answer 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Answer 3"      , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Answer 4"      , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Answer 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Answer 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Answer 3"      , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Answer 4"      , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Qtono2)

static struct BurnInputInfo Sf2InputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp177+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp177+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp177+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp177+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp177+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp177+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2)

static struct BurnInputInfo Sf2ueInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp1fd+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp1fd+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp1fd+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp1fd+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp1fd+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp1fd+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2ue)

static struct BurnInputInfo Sf2yycInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp019+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp019+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp176+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp176+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp176+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp019+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp019+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp176+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp176+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp176+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp019+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp019+2, "service"   },
	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2yyc)

static struct BurnInputInfo Sf2m1InputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp012+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp012+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp012+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp012+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp012+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp012+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2m1)

static struct BurnInputInfo Sf2m3InputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp029+0, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp029+4, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp011+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp011+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp011+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp011+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp011+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp011+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp011+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp186+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp186+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp186+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp029+1, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp029+5, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp010+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp010+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp010+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp010+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp010+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp010+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp010+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp186+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp186+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp186+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp029+6, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp029+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Sf2m3)

static struct BurnInputInfo SfzchInputList[] =
{
	{"P1 Pause"         , BIT_DIGITAL  , CpsInp018+2, "p1 select" },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
 	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },
 	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp018+0, "p1 fire 5" },
 	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp018+6, "p1 fire 6" },

 	{"P2 Pause"         , BIT_DIGITAL  , CpsInp018+3, "p2 select" },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
 	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },
 	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp018+1, "p2 fire 5" },
 	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp018+7, "p2 fire 6" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
};

STDINPUTINFO(Sfzch)

static struct BurnInputInfo SlammastInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Pin"           , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Pin"           , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc001+6, "p3 coin"  },
 	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 1"},
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 2"},
 	{"P3 Pin"           , BIT_DIGITAL  , CpsInp001+7 , "p3 fire 3"},

 	{"P4 Coin"          , BIT_DIGITAL  , CpsInpc003+6, "p4 coin"  },
 	{"P4 Start"         , BIT_DIGITAL  , CpsInpc003+7, "p4 start" },
 	{"P4 Up"            , BIT_DIGITAL  , CpsInpc003+3, "p4 up"    },
 	{"P4 Down"          , BIT_DIGITAL  , CpsInpc003+2, "p4 down"  },
 	{"P4 Left"          , BIT_DIGITAL  , CpsInpc003+1, "p4 left"  },
 	{"P4 Right"         , BIT_DIGITAL  , CpsInpc003+0, "p4 right" },
 	{"P4 Attack"        , BIT_DIGITAL  , CpsInpc003+4, "p4 fire 1"},
 	{"P4 Jump"          , BIT_DIGITAL  , CpsInpc003+5, "p4 fire 2"},
 	{"P4 Pin"           , BIT_DIGITAL  , CpsInp000+7 , "p4 fire 3"},

 	{"Reset"            , BIT_DIGITAL  , &CpsReset   , "reset"    },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6 , "diag"     },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2 , "service"  },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E     , "dip"      },
};

STDINPUTINFO(Slammast)

static struct BurnInputInfo StriderInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Strider)

static struct BurnInputInfo UnsquadInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },

};

STDINPUTINFO(Unsquad)

static struct BurnInputInfo VarthInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Varth)

static struct BurnInputInfo WillowInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
 	{"P1 Fire 3"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
 
 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
 	{"P2 Fire 3"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Willow)

static struct BurnInputInfo WofInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInpc001+6, "p3 coin"  },
 	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 1"},
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 2"},

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Wof)

static struct BurnInputInfo WofchInputList[] =
{
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

 	{"P3 Start"         , BIT_DIGITAL  , CpsInpc001+7, "p3 start" },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInpc001+3, "p3 up"    },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInpc001+2, "p3 down"  },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInpc001+1, "p3 left"  },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInpc001+0, "p3 right" },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInpc001+4, "p3 fire 1"},
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInpc001+5, "p3 fire 2"},

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
};

STDINPUTINFO(Wofch)

static struct BurnInputInfo WofhfhInputList[] =
{
 	{"P1 Coin"          , BIT_DIGITAL  , CpsInp018+0, "p1 coin"   },
 	{"P1 Start"         , BIT_DIGITAL  , CpsInp018+4, "p1 start"  },
 	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
 	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
 	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
 	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
 	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
 	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

 	{"P2 Coin"          , BIT_DIGITAL  , CpsInp018+1, "p2 coin"   },
 	{"P2 Start"         , BIT_DIGITAL  , CpsInp018+5, "p2 start"  },
 	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
 	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
 	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
 	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
 	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
 	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

 	{"P3 Coin"          , BIT_DIGITAL  , CpsInp177+6, "p3 coin"   },
 	{"P3 Start"         , BIT_DIGITAL  , CpsInp177+7, "p3 start"  },
 	{"P3 Up"            , BIT_DIGITAL  , CpsInp177+3, "p3 up"     },
 	{"P3 Down"          , BIT_DIGITAL  , CpsInp177+2, "p3 down"   },
 	{"P3 Left"          , BIT_DIGITAL  , CpsInp177+1, "p3 left"   },
 	{"P3 Right"         , BIT_DIGITAL  , CpsInp177+0, "p3 right"  },
 	{"P3 Attack"        , BIT_DIGITAL  , CpsInp177+4, "p3 fire 1" },
 	{"P3 Jump"          , BIT_DIGITAL  , CpsInp177+5, "p3 fire 2" },

 	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
 	{"Diagnostic"       , BIT_DIGITAL  , CpsInp018+6, "diag"      },
 	{"Service"          , BIT_DIGITAL  , CpsInp018+2, "service"   },
 	{"Dip A"            , BIT_DIPSWITCH, &Cpi01A    , "dip"       },
 	{"Dip B"            , BIT_DIPSWITCH, &Cpi01C    , "dip"       },
 	{"Dip C"            , BIT_DIPSWITCH, &Cpi01E    , "dip"       },
};

STDINPUTINFO(Wofhfh)

// Dip Switch Definitions

#define CPS1_COINAGE_1(dipval) \
	{0     , 0xfe, 0   , 8   , "Coin A"                 }, \
	{dipval, 0x01, 0x07, 0x07, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x06, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x05, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x01, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x07, 0x02, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x07, 0x03, "1 Coin  4 Credits"      }, \
	{dipval, 0x01, 0x07, 0x04, "1 Coin  6 Credits"      }, \
							       \
	{0     , 0xfe, 0   , 8   , "Coin B"                 }, \
	{dipval, 0x01, 0x38, 0x38, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x30, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x28, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x08, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x38, 0x10, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x38, 0x18, "1 Coin  4 Credits"      }, \
	{dipval, 0x01, 0x38, 0x20, "1 Coin  6 Credits"      }, 
	
#define CPS1_COINAGE_2(dipval) \
	{0     , 0xfe, 0   , 8   , "Coinage"                }, \
	{dipval, 0x01, 0x07, 0x07, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x06, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x05, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x01, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x07, 0x02, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x07, 0x03, "1 Coin  4 Credits"      }, \
	{dipval, 0x01, 0x07, 0x04, "1 Coin  6 Credits"      }, 
	
#define CPS1_COINAGE_3(dipval) \
	{0     , 0xfe, 0   , 8   , "Coin A"                 }, \
	{dipval, 0x01, 0x07, 0x06, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x05, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x04, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x07, "2 Coins 1 Credit (1 to cont)"}, \
	{dipval, 0x01, 0x07, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x07, 0x01, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x07, 0x02, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x07, 0x03, "1 Coin  4 Credits"      }, \
							       \
	{0     , 0xfe, 0   , 8   , "Coin B"                 }, \
	{dipval, 0x01, 0x38, 0x30, "4 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x28, "3 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x20, "2 Coins 1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x38, "2 Coins 1 Credit (1 to cont)"}, \
	{dipval, 0x01, 0x38, 0x00, "1 Coin  1 Credit"       }, \
	{dipval, 0x01, 0x38, 0x08, "1 Coin  2 Credits"      }, \
	{dipval, 0x01, 0x38, 0x10, "1 Coin  3 Credits"      }, \
	{dipval, 0x01, 0x38, 0x18, "1 Coin  4 Credits"      }, 
	
#define CPS1_DIFFICULTY_1(dipval) \
	{0   , 0xfe, 0   , 8   , "Difficulty"               }, \
	{dipval, 0x01, 0x07, 0x00, "1 (Easiest)"            }, \
	{dipval, 0x01, 0x07, 0x01, "2"                      }, \
	{dipval, 0x01, 0x07, 0x02, "3"                      }, \
	{dipval, 0x01, 0x07, 0x03, "4 (Normal)"             }, \
	{dipval, 0x01, 0x07, 0x04, "5"                      }, \
	{dipval, 0x01, 0x07, 0x05, "6"                      }, \
	{dipval, 0x01, 0x07, 0x06, "7"                      }, \
	{dipval, 0x01, 0x07, 0x07, "8 (Hardest)"            },
	
#define CPS1_DIFFICULTY_2(dipval) \
	{0   , 0xfe, 0   , 8   , "Difficulty"               }, \
	{dipval, 0x01, 0x07, 0x03, "1 (Easiest)"            }, \
	{dipval, 0x01, 0x07, 0x02, "2"                      }, \
	{dipval, 0x01, 0x07, 0x01, "3"                      }, \
	{dipval, 0x01, 0x07, 0x00, "4 (Normal)"             }, \
	{dipval, 0x01, 0x07, 0x04, "5"                      }, \
	{dipval, 0x01, 0x07, 0x05, "6"                      }, \
	{dipval, 0x01, 0x07, 0x06, "7"                      }, \
	{dipval, 0x01, 0x07, 0x07, "8 (Hardest)"            },


static struct BurnDIPInfo CaptcommDIPList[]=
{
	// Defaults
	{0x23, 0xff, 0xff, 0x00, NULL                     },
	{0x24, 0xff, 0xff, 0x0b, NULL                     },
	{0x25, 0xff, 0xff, 0x64, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x23)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x23, 0x01, 0x40, 0x00, "Off"                    },
	{0x23, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x24)

	{0   , 0xfe, 0   , 4   , "Difficulty 2"           },
	{0x24, 0x01, 0x18, 0x00, "Easy"                   },
	{0x24, 0x01, 0x18, 0x08, "Normal"                 },
	{0x24, 0x01, 0x18, 0x10, "Hard"                   },
	{0x24, 0x01, 0x18, 0x18, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Play Mode"              },
	{0x24, 0x01, 0xc0, 0x80, "1 Player"               },
	{0x24, 0x01, 0xc0, 0x00, "2 Player"               },
	{0x24, 0x01, 0xc0, 0x40, "3 Player"               },
	{0x24, 0x01, 0xc0, 0xc0, "4 Player"               },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x25, 0x01, 0x03, 0x03, "1"                      },
	{0x25, 0x01, 0x03, 0x00, "2"                      },
	{0x25, 0x01, 0x03, 0x01, "3"                      },
	{0x25, 0x01, 0x03, 0x02, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x25, 0x01, 0x04, 0x00, "Off"                    },
	{0x25, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x25, 0x01, 0x08, 0x00, "Off"                    },
	{0x25, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x25, 0x01, 0x10, 0x00, "Off"                    },
	{0x25, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x25, 0x01, 0x20, 0x00, "Off"                    },
	{0x25, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x25, 0x01, 0x40, 0x00, "Off"                    },
	{0x25, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x25, 0x01, 0x80, 0x00, "Game"                   },
	{0x25, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Captcomm)

static struct BurnDIPInfo Cworld2jDIPList[]=
{
	// Defaults
	{0x0f, 0xff, 0xff, 0x00, NULL                     },
	{0x10, 0xff, 0xff, 0x01, NULL                     },
	{0x11, 0xff, 0xff, 0x64, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x0f)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x0f, 0x01, 0x40, 0x00, "Off"                    },
	{0x0f, 0x01, 0x40, 0x40, "On"                     },

	{0   , 0xfe, 0   , 2   , "Extended Test Mode"     },
	{0x0f, 0x01, 0x80, 0x00, "Off"                    },
	{0x0f, 0x01, 0x80, 0x80, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 4   , "Difficulty"             },
	{0x10, 0x01, 0x07, 0x01, "0"                      },
	{0x10, 0x01, 0x07, 0x02, "1"                      },
	{0x10, 0x01, 0x07, 0x03, "2"                      },
	{0x10, 0x01, 0x07, 0x04, "3"                      },
	{0x10, 0x01, 0x07, 0x05, "4"                      },

	{0   , 0xfe, 0   , 3   , "Extend"                 },
	{0x10, 0x01, 0x18, 0x18, "D"                      },
	{0x10, 0x01, 0x18, 0x08, "E"                      },
	{0x10, 0x01, 0x18, 0x00, "N"                      },

	{0   , 0xfe, 0   , 5   , "Lives"                  },
	{0x10, 0x01, 0xe0, 0xe0, "1"                      },
	{0x10, 0x01, 0xe0, 0x60, "2"                      },
	{0x10, 0x01, 0xe0, 0x00, "3"                      },
	{0x10, 0x01, 0xe0, 0x40, "4"                      },
	{0x10, 0x01, 0xe0, 0x20, "5"                      },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x11, 0x01, 0x04, 0x00, "Off"                    },
	{0x11, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x11, 0x01, 0x08, 0x00, "Off"                    },
	{0x11, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x11, 0x01, 0x10, 0x00, "Off"                    },
	{0x11, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x11, 0x01, 0x20, 0x00, "Off"                    },
	{0x11, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x11, 0x01, 0x40, 0x00, "Off"                    },
	{0x11, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x11, 0x01, 0x80, 0x00, "Game"                   },
	{0x11, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Cworld2j)

static struct BurnDIPInfo DinoDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1b, 0x01, 0x08, 0x00, "Off"                    },
	{0x1b, 0x01, 0x08, 0x08, "On"                     },
};

STDDIPINFO(Dino)

static struct BurnDIPInfo FfightDIPList[]=
{
	// Defaults
	{0x14, 0xff, 0xff, 0x00, NULL                     },
	{0x15, 0xff, 0xff, 0x0b, NULL                     },
	{0x16, 0xff, 0xff, 0x64, NULL                     },
		
	// Dip A
	CPS1_COINAGE_1(0x14)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x14, 0x01, 0x40, 0x00, "Off"                    },
	{0x14, 0x01, 0x40, 0x40, "On"                     },
		
	// Dip B
	CPS1_DIFFICULTY_1(0x15)

	{0   , 0xfe, 0   , 4   , "Difficulty 2"           },
	{0x15, 0x01, 0x18, 0x00, "Easy"                   },
	{0x15, 0x01, 0x18, 0x08, "Normal"                 },
	{0x15, 0x01, 0x18, 0x10, "Hard"                   },
	{0x15, 0x01, 0x18, 0x18, "Hardest"                },

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x15, 0x01, 0x60, 0x00, "100k"                   },
	{0x15, 0x01, 0x60, 0x20, "200k"                   },
	{0x15, 0x01, 0x60, 0x40, "100k and every 200k"    },
	{0x15, 0x01, 0x60, 0x60, "None"                   },
	
	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x16, 0x01, 0x03, 0x03, "1"                      },
	{0x16, 0x01, 0x03, 0x00, "2"                      },
	{0x16, 0x01, 0x03, 0x01, "3"                      },
	{0x16, 0x01, 0x03, 0x02, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x16, 0x01, 0x04, 0x00, "Off"                    },
	{0x16, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x16, 0x01, 0x08, 0x00, "Off"                    },
	{0x16, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x16, 0x01, 0x10, 0x00, "Off"                    },
	{0x16, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x16, 0x01, 0x20, 0x00, "Off"                    },
	{0x16, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x16, 0x01, 0x40, 0x00, "Off"                    },
	{0x16, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x16, 0x01, 0x80, 0x00, "Game"                   },
	{0x16, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Ffight)

static struct BurnDIPInfo KnightsDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x64, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Enemys Attack Frequency"},
	{0x1c, 0x01, 0x07, 0x00, "1 (Easiest)"            },
	{0x1c, 0x01, 0x07, 0x01, "2"                      },
	{0x1c, 0x01, 0x07, 0x02, "3"                      },
	{0x1c, 0x01, 0x07, 0x03, "4 (Normal)"             },
	{0x1c, 0x01, 0x07, 0x04, "5"                      },
	{0x1c, 0x01, 0x07, 0x05, "6"                      },
	{0x1c, 0x01, 0x07, 0x06, "7"                      },
	{0x1c, 0x01, 0x07, 0x07, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 8   , "Enemys Attack Power"    },
	{0x1c, 0x01, 0x38, 0x38, "1 (Easiest)"            },
	{0x1c, 0x01, 0x38, 0x30, "2"                      },
	{0x1c, 0x01, 0x38, 0x28, "3"                      },
	{0x1c, 0x01, 0x38, 0x00, "4 (Normal)"             },
	{0x1c, 0x01, 0x38, 0x08, "5"                      },
	{0x1c, 0x01, 0x38, 0x10, "6"                      },
	{0x1c, 0x01, 0x38, 0x18, "7"                      },
	{0x1c, 0x01, 0x38, 0x20, "8 (Hardest)"            },

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x1c, 0x01, 0x40, 0x40, "1"                      },
	{0x1c, 0x01, 0x40, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Play Mode"              },
	{0x1c, 0x01, 0x80, 0x80, "2P"                     },
	{0x1c, 0x01, 0x80, 0x00, "3P"                     },

	// Dip C
	{0   , 0xfe, 0   , 4   , "Lives"                  },
	{0x1d, 0x01, 0x03, 0x03, "1"                      },
	{0x1d, 0x01, 0x03, 0x00, "2"                      },
	{0x1d, 0x01, 0x03, 0x01, "3"                      },
	{0x1d, 0x01, 0x03, 0x02, "4"                      },

	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip"                   },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Knights)

static struct BurnDIPInfo KodjDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x64, NULL                     },
	
	// Dip A
	CPS1_COINAGE_2(0x1b)

	{0   , 0xfe, 0   , 2   , "Coin Slots"             },
	{0x1b, 0x01, 0x08, 0x08, "1"                      },
	{0x1b, 0x01, 0x08, 0x00, "3"                      },

	{0   , 0xfe, 0   , 2   , "Play Mode"              },
	{0x1b, 0x01, 0x10, 0x10, "2 Players"              },
	{0x1b, 0x01, 0x10, 0x00, "3 Players"              },

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	{0   , 0xfe, 0   , 8   , "Lives"                  },
	{0x1c, 0x01, 0x38, 0x08, "1"                      },
	{0x1c, 0x01, 0x38, 0x00, "2"                      },
	{0x1c, 0x01, 0x38, 0x10, "3"                      },
	{0x1c, 0x01, 0x38, 0x18, "4"                      },
	{0x1c, 0x01, 0x38, 0x20, "5"                      },
	{0x1c, 0x01, 0x38, 0x28, "6"                      },
	{0x1c, 0x01, 0x38, 0x30, "7"                      },
	{0x1c, 0x01, 0x38, 0x38, "8"                      },

	{0   , 0xfe, 0   , 4   , "Bonus Life"             },
	{0x1c, 0x01, 0xc0, 0x40, "80k and every 400k"     },
	{0x1c, 0x01, 0xc0, 0x80, "160k and every 450k"    },
	{0x1c, 0x01, 0xc0, 0x00, "200k and every 450k"    },
	{0x1c, 0x01, 0xc0, 0xc0, "None"                   },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
	{0x1d, 0x01, 0x04, 0x00, "Off"                    },
	{0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1d, 0x01, 0x08, 0x00, "Off"                    },
	{0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
	{0x1d, 0x01, 0x10, 0x00, "Off"                    },
	{0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
	{0x1d, 0x01, 0x20, 0x00, "Off"                    },
	{0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
	{0x1d, 0x01, 0x40, 0x00, "Off"                    },
	{0x1d, 0x01, 0x40, 0x40, "On"                     },
	
	{0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Kodj)

static struct BurnDIPInfo PunisherDIPList[]=
{
	// Defaults
	{0x13, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x13, 0x01, 0x08, 0x00, "Off"                    },
	{0x13, 0x01, 0x08, 0x08, "On"                     },
};

STDDIPINFO(Punisher)

static struct BurnDIPInfo Sf2DIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x64, NULL                     },
	
	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
        {0x1d, 0x01, 0x04, 0x00, "Off"                    },
        {0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
        {0x1d, 0x01, 0x08, 0x00, "Off"                    },
        {0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
        {0x1d, 0x01, 0x10, 0x00, "Off"                    },
        {0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
        {0x1d, 0x01, 0x20, 0x00, "Off"                    },
        {0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
        {0x1d, 0x01, 0x40, 0x00, "Off"                    },
        {0x1d, 0x01, 0x40, 0x40, "On"                     },
        
        {0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2)

static struct BurnDIPInfo Sf2jDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },
	{0x1c, 0xff, 0xff, 0x03, NULL                     },
	{0x1d, 0xff, 0xff, 0x64, NULL                     },

	// Dip A
	CPS1_COINAGE_1(0x1b)

	{0   , 0xfe, 0   , 2   , "2C to Start, 1 to Cont" },
	{0x1b, 0x01, 0x40, 0x00, "Off"                    },
	{0x1b, 0x01, 0x40, 0x40, "On"                     },

	// Dip B
	CPS1_DIFFICULTY_1(0x1c)

	{0   , 0xfe, 0   , 2   , "2 Players Game"         },
	{0x1c, 0x01, 0x08, 0x00, "1 Credit/No Continue"   },
	{0x1c, 0x01, 0x08, 0x08, "2 Credits/Winner Continue"},

	// Dip C
	{0   , 0xfe, 0   , 2   , "Free Play"              },
        {0x1d, 0x01, 0x04, 0x00, "Off"                    },
        {0x1d, 0x01, 0x04, 0x04, "On"                     },

	{0   , 0xfe, 0   , 2   , "Freeze"                 },
        {0x1d, 0x01, 0x08, 0x00, "Off"                    },
        {0x1d, 0x01, 0x08, 0x08, "On"                     },

	{0   , 0xfe, 0   , 2   , "Flip Screen"            },
        {0x1d, 0x01, 0x10, 0x00, "Off"                    },
        {0x1d, 0x01, 0x10, 0x10, "On"                     },

	{0   , 0xfe, 0   , 2   , "Demo Sound"             },
        {0x1d, 0x01, 0x20, 0x00, "Off"                    },
        {0x1d, 0x01, 0x20, 0x20, "On"                     },

	{0   , 0xfe, 0   , 2   , "Allow Continue"         },
        {0x1d, 0x01, 0x40, 0x00, "Off"                    },
        {0x1d, 0x01, 0x40, 0x40, "On"                     },
        
        {0   , 0xfe, 0   , 2   , "Game Mode"              },
	{0x1d, 0x01, 0x80, 0x00, "Game"                   },
	{0x1d, 0x01, 0x80, 0x80, "Test"                   },
};

STDDIPINFO(Sf2j)

static struct BurnDIPInfo SlammastDIPList[]=
{
	// Defaults
	{0x23, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x23, 0x01, 0x08, 0x08, "Off"                    },
	{0x23, 0x01, 0x08, 0x00, "On"                     },
};

STDDIPINFO(Slammast)

static struct BurnDIPInfo WofDIPList[]=
{
	// Defaults
	{0x1b, 0xff, 0xff, 0x00, NULL                     },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"                 },
	{0x1b, 0x01, 0x08, 0x08, "Off"                    },
	{0x1b, 0x01, 0x08, 0x00, "On"                     },
};

STDDIPINFO(Wof)

// Rom Definitions

#define A_BOARD_PLDS						\
	{ "buf1",          0x000117, 0xeb122de7, BRF_OPT },	\
	{ "ioa1",          0x000117, 0x59c7ee3b, BRF_OPT },	\
	{ "prg1",          0x000117, 0xf1129744, BRF_OPT },	\
	{ "rom1",          0x000117, 0x41dc73b9, BRF_OPT },	\
	{ "sou1",          0x000117, 0x84f4b2fe, BRF_OPT },
	
#define A_BOARD_QSOUND_PLDS					\
	{ "buf1",          0x000117, 0xeb122de7, BRF_OPT },	\
	{ "ioa1",          0x000117, 0x59c7ee3b, BRF_OPT },	\
	{ "prg2",          0x000117, 0x4386879a, BRF_OPT },	\
	{ "rom1",          0x000117, 0x41dc73b9, BRF_OPT },	\

static struct BurnRomInfo CaptcommjRomDesc[] = {
	{ "ccj_23f.8f",      0x080000, 0x5b482b62, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ccj_22f.7f",    0x080000, 0x0fd34195, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ccj_24f.9e",    0x020000, 0x3a794f25, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ccj_28f.9f",    0x020000, 0xfc3c2906, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "cc_01.3a",    0x080000, 0x7261d8ba, BRF_GRA | CPS1_TILES },
	{ "cc_02.4a",    0x080000, 0x6a60f949, BRF_GRA | CPS1_TILES },
	{ "cc_03.5a",    0x080000, 0x00637302, BRF_GRA | CPS1_TILES },
	{ "cc_04.6a",    0x080000, 0xcc87cf61, BRF_GRA | CPS1_TILES },
	{ "cc_05.7a",    0x080000, 0x28718bed, BRF_GRA | CPS1_TILES },
	{ "cc_06.8a",    0x080000, 0xd4acc53a, BRF_GRA | CPS1_TILES },
	{ "cc_07.9a",    0x080000, 0x0c69f151, BRF_GRA | CPS1_TILES },
	{ "cc_08.10a",    0x080000, 0x1f9ebb97, BRF_GRA | CPS1_TILES },

	{ "ccj_09.12a",     0x010000, 0x698e8b58, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ccj_18.11c",     0x020000, 0x6de2c2db, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ccj_19.12c",     0x020000, 0xb99091ae, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "cc63b.1a",      0x000117, 0xcae8f0f9, BRF_OPT },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "ccprg.11d",     0x000117, 0xe1c225c4, BRF_OPT },
	{ "ioc1.ic7",      0x000117, 0x0d182081, BRF_OPT },	// c-board PLDs
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Captcommj)
STD_ROM_FN(Captcommj)

static struct BurnRomInfo Cworld2jRomDesc[] = {
	{ "q5_36.12f",      0x020000, 0x38a08099, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_42.12h",      0x020000, 0x4d29b3a4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_37.13f",      0x020000, 0xeb547ebc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_43.13h",      0x020000, 0x3ef65ea8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_34.10f",      0x020000, 0x7fcc1317, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_40.10h",      0x020000, 0x7f14b7b4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_35.11f",      0x020000, 0xabacee26, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "q5_41.11h",      0x020000, 0xd3654067, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "q5_09.4b",      0x020000, 0x48496d80, BRF_GRA | CPS1_TILES },
	{ "q5_01.4a",      0x020000, 0xc5453f56, BRF_GRA | CPS1_TILES },
	{ "q5_13.9b",      0x020000, 0xc741ac52, BRF_GRA | CPS1_TILES },
	{ "q5_05.9a",      0x020000, 0x143e068f, BRF_GRA | CPS1_TILES },
	{ "q5_24.5e",      0x020000, 0xb419d139, BRF_GRA | CPS1_TILES },
	{ "q5_17.5c",      0x020000, 0xbd3b4d11, BRF_GRA | CPS1_TILES },
	{ "q5_38.8h",      0x020000, 0x9c24670c, BRF_GRA | CPS1_TILES },
	{ "q5_32.8f",      0x020000, 0x3ef9c7c2, BRF_GRA | CPS1_TILES },
	{ "q5_10.5b",      0x020000, 0x119e5e93, BRF_GRA | CPS1_TILES },
	{ "q5_02.5a",      0x020000, 0xa2cadcbe, BRF_GRA | CPS1_TILES },
	{ "q5_14.10b",      0x020000, 0xa8755f82, BRF_GRA | CPS1_TILES },
	{ "q5_06.10a",      0x020000, 0xc92a91fc, BRF_GRA | CPS1_TILES },
	{ "q5_25.7e",      0x020000, 0x979237cb, BRF_GRA | CPS1_TILES },
	{ "q5_18.7c",      0x020000, 0xc57da03c, BRF_GRA | CPS1_TILES },
	{ "q5_39.9h",      0x020000, 0xa5839b25, BRF_GRA | CPS1_TILES },
	{ "q5_33.9f",      0x020000, 0x04d03930, BRF_GRA | CPS1_TILES },

	{ "q5_23.13b",      0x010000, 0xe14dc524, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "q5_30.12c",      0x020000, 0xd10c1b68, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "q5_31.13c",      0x020000, 0x7d17e496, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
};

STD_ROM_PICK(Cworld2j)
STD_ROM_FN(Cworld2j)

static struct BurnRomInfo DinojRomDesc[] = {
	{ "cdj-23a.8f",    0x080000, 0x5f3ece96, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cdj-22a.7f",    0x080000, 0xa0d8de29, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "cde_21a.rom",   0x080000, 0x66d23de2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd_gfx01.rom",  0x080000, 0x8da4f917, BRF_GRA | CPS1_TILES },
	{ "cd_gfx03.rom",  0x080000, 0x6c40f603, BRF_GRA | CPS1_TILES },
	{ "cd_gfx02.rom",  0x080000, 0x09c8fc2d, BRF_GRA | CPS1_TILES },
	{ "cd_gfx04.rom",  0x080000, 0x637ff38f, BRF_GRA | CPS1_TILES },
	{ "cd_gfx05.rom",  0x080000, 0x470befee, BRF_GRA | CPS1_TILES },
	{ "cd_gfx07.rom",  0x080000, 0x22bfb7a3, BRF_GRA | CPS1_TILES },
	{ "cd_gfx06.rom",  0x080000, 0xe7599ac4, BRF_GRA | CPS1_TILES },
	{ "cd_gfx08.rom",  0x080000, 0x211b4b15, BRF_GRA | CPS1_TILES },

	{ "cd_q.rom",      0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd_q1.rom",     0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q2.rom",     0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q3.rom",     0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q4.rom",     0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
	
	{ "cd63b.1a",      0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",     0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic1",      0x000117, 0x0d182081, BRF_OPT },	// c-board PLDs
};

STD_ROM_PICK(Dinoj)
STD_ROM_FN(Dinoj)

static struct BurnRomInfo FfightjRomDesc[] = {
	{ "ff36.bin",      0x020000, 0xf9a5ce83, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff42.bin",      0x020000, 0x65f11215, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff37.bin",      0x020000, 0xe1033784, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ff43.bin",      0x020000, 0xb6dee1c3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_34.10f",    0x020000, 0x0c8dc3fc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_40.10h",    0x020000, 0x8075bab9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_35.11f",    0x020000, 0x4a934121, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "ffj_41.11h",    0x020000, 0x2af68154, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "ffj_09.4b",     0x020000, 0x5b116d0d, BRF_GRA | CPS1_TILES },
	{ "ffj_01.4a",     0x020000, 0x815b1797, BRF_GRA | CPS1_TILES },
	{ "ffj_13.9b",     0x020000, 0x8721a7da, BRF_GRA | CPS1_TILES },
	{ "ffj_05.9a",     0x020000, 0xd0fcd4b5, BRF_GRA | CPS1_TILES },
	{ "ffj_24.5e",     0x020000, 0xa1ab607a, BRF_GRA | CPS1_TILES },
	{ "ffj_17.5c",     0x020000, 0x2dc18cf4, BRF_GRA | CPS1_TILES },
	{ "ffj_38.8h",     0x020000, 0x6535a57f, BRF_GRA | CPS1_TILES },
	{ "ffj_32.8f",     0x020000, 0xc8bc4a57, BRF_GRA | CPS1_TILES },
	{ "ffj_10.5b",     0x020000, 0x624a924a, BRF_GRA | CPS1_TILES },
	{ "ffj_02.5a",     0x020000, 0x5d91f694, BRF_GRA | CPS1_TILES },
	{ "ffj_14.10b",    0x020000, 0x0a2e9101, BRF_GRA | CPS1_TILES },
	{ "ffj_06.10a",    0x020000, 0x1c18f042, BRF_GRA | CPS1_TILES },
	{ "ffj_25.7e",     0x020000, 0x6e8181ea, BRF_GRA | CPS1_TILES },
	{ "ffj_18.7c",     0x020000, 0xb19ede59, BRF_GRA | CPS1_TILES },
	{ "ffj_39.9h",     0x020000, 0x9416b477, BRF_GRA | CPS1_TILES },
	{ "ffj_33.9f",     0x020000, 0x7369fa07, BRF_GRA | CPS1_TILES },

	{ "ff_23.13c",     0x010000, 0xb8367eb5, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ffj_30.12e",    0x020000, 0x375c66e7, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "ffj_31.13e",    0x020000, 0x1ef137f9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s222b.1a",      0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },	// b-board PLDs
	{ "lwio.12c",      0x000117, 0xad52b90c, BRF_OPT },
};

STD_ROM_PICK(Ffightj)
STD_ROM_FN(Ffightj)

static struct BurnRomInfo KnightsjRomDesc[] = {
	{ "krj30.bin",     0x020000, 0xad3d1a8e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "krj37.bin",     0x020000, 0xe694a491, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "krj31.bin",     0x020000, 0x85596094, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "krj38.bin",     0x020000, 0x9198bf8f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kr_22.rom",     0x080000, 0xd0b671a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "kr_gfx1.rom",   0x080000, 0x9e36c1a4, BRF_GRA | CPS1_TILES },
	{ "kr_gfx3.rom",   0x080000, 0xc5832cae, BRF_GRA | CPS1_TILES },
	{ "kr_gfx2.rom",   0x080000, 0xf095be2d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx4.rom",   0x080000, 0x179dfd96, BRF_GRA | CPS1_TILES },
	{ "kr_gfx5.rom",   0x080000, 0x1f4298d2, BRF_GRA | CPS1_TILES },
	{ "kr_gfx7.rom",   0x080000, 0x37fa8751, BRF_GRA | CPS1_TILES },
	{ "kr_gfx6.rom",   0x080000, 0x0200bc3d, BRF_GRA | CPS1_TILES },
	{ "kr_gfx8.rom",   0x080000, 0x0bb2b4e7, BRF_GRA | CPS1_TILES },

	{ "kr_09.rom",     0x010000, 0x5e44d9ee, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kr_18.rom",     0x020000, 0xda69d15f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kr_19.rom",     0x020000, 0xbfc654e9, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
};

STD_ROM_PICK(Knightsj)
STD_ROM_FN(Knightsj)

static struct BurnRomInfo KodjRomDesc[] = {
	{ "kd30.bin",      0x020000, 0xebc788ad, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd37.bin",      0x020000, 0xe55c3529, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd31.bin",      0x020000, 0xc710d722, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd38.bin",      0x020000, 0x57d6ed3a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "kd33.bin",      0x080000, 0x9bd7ad4b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "kod02.rom",     0x080000, 0xe45b8701, BRF_GRA | CPS1_TILES },
	{ "kod04.rom",     0x080000, 0xa7750322, BRF_GRA | CPS1_TILES },
	{ "kod01.rom",     0x080000, 0x5f74bf78, BRF_GRA | CPS1_TILES },
	{ "kod03.rom",     0x080000, 0x5e5303bf, BRF_GRA | CPS1_TILES },
	{ "kod11.rom",     0x080000, 0x113358f3, BRF_GRA | CPS1_TILES },
	{ "kod13.rom",     0x080000, 0x38853c44, BRF_GRA | CPS1_TILES },
	{ "kod10.rom",     0x080000, 0x9ef36604, BRF_GRA | CPS1_TILES },
	{ "kod12.rom",     0x080000, 0x402b9b4f, BRF_GRA | CPS1_TILES },

	{ "kd09.bin",      0x010000, 0xbac6ec26, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "kd18.bin",      0x020000, 0x4c63181d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "kd19.bin",      0x020000, 0x92941b80, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
};

STD_ROM_PICK(Kodj)
STD_ROM_FN(Kodj)

static struct BurnRomInfo PunisherjRomDesc[] = {
	{ "psj23.bin",     0x080000, 0x6b2fda52, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "psj22.bin",     0x080000, 0xe01036bc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "ps_21.rom",     0x080000, 0x8affa5a9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "ps_gfx1.rom",   0x080000, 0x77b7ccab, BRF_GRA | CPS1_TILES },
	{ "ps_gfx3.rom",   0x080000, 0x0122720b, BRF_GRA | CPS1_TILES },
	{ "ps_gfx2.rom",   0x080000, 0x64fa58d4, BRF_GRA | CPS1_TILES },
	{ "ps_gfx4.rom",   0x080000, 0x60da42c8, BRF_GRA | CPS1_TILES },
	{ "ps_gfx5.rom",   0x080000, 0xc54ea839, BRF_GRA | CPS1_TILES },
	{ "ps_gfx7.rom",   0x080000, 0x04c5acbd, BRF_GRA | CPS1_TILES },
	{ "ps_gfx6.rom",   0x080000, 0xa544f4cc, BRF_GRA | CPS1_TILES },
	{ "ps_gfx8.rom",   0x080000, 0x8f02f436, BRF_GRA | CPS1_TILES },

	{ "ps_q.rom",      0x020000, 0x49ff4446, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "ps_q1.rom",     0x080000, 0x31fd8726, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps_q2.rom",     0x080000, 0x980a9eef, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps_q3.rom",     0x080000, 0x0dd44491, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "ps_q4.rom",     0x080000, 0xbed42f03, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
};

STD_ROM_PICK(Punisherj)
STD_ROM_FN(Punisherj)

static struct BurnRomInfo Sf2hfjRomDesc[] = {
	{ "s2tj_23.8f",   0x080000, 0xea73b4dc, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },
	{ "s2tj_22.7f",    0x080000, 0xaea6e035, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },
	{ "s2tj_21.6f",    0x080000, 0xfd200288, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },

	{ "s92_01.3a",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.4a",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.5a",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.6a",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.7a",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.8a",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.9a",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.10a",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s2t_10.3c",    0x080000, 0x3c042686, BRF_GRA | CPS1_TILES },
	{ "s2t_11.4c",    0x080000, 0x8b7e7183, BRF_GRA | CPS1_TILES },
	{ "s2t_12.5c",    0x080000, 0x293c888c, BRF_GRA | CPS1_TILES },
	{ "s2t_13.6c",    0x080000, 0x842b35a4, BRF_GRA | CPS1_TILES },

	{ "s92_09.12a",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.11c",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.12c",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
	
	A_BOARD_PLDS
	
	{ "s9263b.1a",     0x000117, 0x00000000, BRF_OPT | BRF_NODUMP },	// b-board PLDs
	{ "iob1.12d",      0x000117, 0x3abc0700, BRF_OPT },
	{ "bprg1.11d",      0x000117, 0x31793da7, BRF_OPT },
	{ "ioc1.ic7",      0x000117, 0x0d182081, BRF_OPT },	
	{ "c632.ic1",      0x000117, 0x0fbd9270, BRF_OPT },
};

STD_ROM_PICK(Sf2hfj)
STD_ROM_FN(Sf2hfj)

static struct BurnRomInfo SfzchRomDesc[] = {
	{ "sfzch23",       0x080000, 0x1140743f, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza22",        0x080000, 0x8d9b2480, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfzch21",       0x080000, 0x5435225d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza20",        0x080000, 0x806e8f38, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sfz01",         0x080000, 0x0dd53e62, BRF_GRA | CPS1_TILES },
	{ "sfz02",         0x080000, 0x94c31e3f, BRF_GRA | CPS1_TILES },
	{ "sfz03",         0x080000, 0x9584ac85, BRF_GRA | CPS1_TILES },
	{ "sfz04",         0x080000, 0xb983624c, BRF_GRA | CPS1_TILES },
	{ "sfz05",         0x080000, 0x2b47b645, BRF_GRA | CPS1_TILES },
	{ "sfz06",         0x080000, 0x74fd9fb1, BRF_GRA | CPS1_TILES },
	{ "sfz07",         0x080000, 0xbb2c734d, BRF_GRA | CPS1_TILES },
	{ "sfz08",         0x080000, 0x454f7868, BRF_GRA | CPS1_TILES },
	{ "sfz10",         0x080000, 0x2a7d675e, BRF_GRA | CPS1_TILES },
	{ "sfz11",         0x080000, 0xe35546c8, BRF_GRA | CPS1_TILES },
	{ "sfz12",         0x080000, 0xf122693a, BRF_GRA | CPS1_TILES },
	{ "sfz13",         0x080000, 0x7cf942c8, BRF_GRA | CPS1_TILES },
	{ "sfz14",         0x080000, 0x09038c81, BRF_GRA | CPS1_TILES },
	{ "sfz15",         0x080000, 0x1aa17391, BRF_GRA | CPS1_TILES },
	{ "sfz16",         0x080000, 0x19a5abd6, BRF_GRA | CPS1_TILES },
	{ "sfz17",         0x080000, 0x248b3b73, BRF_GRA | CPS1_TILES },

	{ "sfz09",         0x010000, 0xc772628b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "sfz18",         0x020000, 0x61022b2d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sfz19",         0x020000, 0x3b5886d5, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sfzch)
STD_ROM_FN(Sfzch)

static struct BurnRomInfo MbomberjRomDesc[] = {
	{ "mbj23e",        0x080000, 0x0d06036a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbe_24b.rom",   0x020000, 0x95d5e729, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_28b.rom",   0x020000, 0xb1c7cbcb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_25b.rom",   0x020000, 0xa50d3fd4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_29b.rom",   0x020000, 0x08e32e56, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_21a.rom",   0x080000, 0xd5007b05, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbe_20a.rom",   0x080000, 0xaeb557b0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mbj_01.bin",    0x080000, 0xa53b1c81, BRF_GRA | CPS1_TILES },
	{ "mbj_03.bin",    0x080000, 0x23fe10f6, BRF_GRA | CPS1_TILES },
	{ "mbj_02.bin",    0x080000, 0xcb866c2f, BRF_GRA | CPS1_TILES },
	{ "mbj_04.bin",    0x080000, 0xc9143e75, BRF_GRA | CPS1_TILES },
	{ "mb_05.bin",     0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_07.bin",     0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_06.bin",     0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.bin",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.bin",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_12.bin",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_11.bin",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.bin",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_qa.rom",     0x020000, 0xe21a03c4, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb_q1.bin",     0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q2.bin",     0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q3.bin",     0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q4.bin",     0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q5.bin",     0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q6.bin",     0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q7.bin",     0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q8.bin",     0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
};

STD_ROM_PICK(Mbomberj)
STD_ROM_FN(Mbomberj)

static struct BurnRomInfo MbombrdjRomDesc[] = {
	{ "mbd_26.bin",    0x020000, 0x72b7451c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdj_30.bin",   0x020000, 0xbeff31cf, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_27.bin",    0x020000, 0x4086f534, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_31.bin",    0x020000, 0x085f47f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_24.bin",    0x020000, 0xc20895a5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_28.bin",    0x020000, 0x2618d5e1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_25.bin",    0x020000, 0x9bdb6b11, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_29.bin",    0x020000, 0x3f52d5e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_21.bin",    0x080000, 0x690c026a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbd_20.bin",    0x080000, 0xb8b2139b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mbj_01.bin",    0x080000, 0xa53b1c81, BRF_GRA | CPS1_TILES },
	{ "mbj_03.bin",    0x080000, 0x23fe10f6, BRF_GRA | CPS1_TILES },
	{ "mbj_02.bin",    0x080000, 0xcb866c2f, BRF_GRA | CPS1_TILES },
	{ "mbj_04.bin",    0x080000, 0xc9143e75, BRF_GRA | CPS1_TILES },
	{ "mb_05.bin",     0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_07.bin",     0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_06.bin",     0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.bin",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.bin",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_12.bin",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_11.bin",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.bin",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_q.bin",      0x020000, 0xd6fa76d1, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb_q1.bin",     0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q2.bin",     0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q3.bin",     0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q4.bin",     0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q5.bin",     0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q6.bin",     0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q7.bin",     0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q8.bin",     0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
	
	A_BOARD_QSOUND_PLDS
};

STD_ROM_PICK(Mbombrdj)
STD_ROM_FN(Mbombrdj)

static struct BurnRomInfo WofchRomDesc[] = {
	{ "tk2(ch).23",    0x080000, 0x4e0b8dee, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2(ch).22",    0x080000, 0xd0937a8d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk205.bin",     0x080000, 0xe4a44d53, BRF_GRA | CPS1_TILES },
	{ "tk206.bin",     0x080000, 0x58066ba8, BRF_GRA | CPS1_TILES },
	{ "tk2(ch).06",    0x080000, 0xcc9006c9, BRF_GRA | CPS1_TILES },
	{ "tk208.bin",     0x080000, 0xd4a19a02, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.rom",    0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2_q1.rom",    0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q2.rom",    0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q3.rom",    0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q4.rom",    0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Wofch)
STD_ROM_FN(Wofch)

// Game config

typedef void (*KabukiDecode)();
static KabukiDecode KabukiDecodeFunction;

static int GameHasStars = 0;

struct GameConfig {
	const char *DriverName;
	int CpsBId;
	int CpsMapperId;
	int CpsStars;
	KabukiDecode DecodeFunction;
};

static const struct GameConfig ConfigTable[] =
{
	{ "1941"        , CPS_B_05    , mapper_YI24B , 0, NULL                },
	{ "1941j"       , CPS_B_05    , mapper_YI24B , 0, NULL                },
	{ "3wonders"    , CPS_B_21_BT1, mapper_RT24B , 0, NULL                },
	{ "3wondersu"   , CPS_B_21_BT1, mapper_RT24B , 0, NULL                },
	{ "wonder3"     , CPS_B_21_BT1, mapper_RT22B , 0, NULL                },
	{ "3wondersh"   , CPS_B_02    , mapper_RT24B , 0, NULL                },
	{ "captcomm"    , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommr1"  , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },	
	{ "captcommu"   , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommj"   , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "captcommjr1" , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },	
	{ "captcommb"   , CPS_B_21_BT3, mapper_CC63B , 0, NULL                },
	{ "cawing"      , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cawingr1"    , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cawingu"     , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cawingj"     , CPS_B_16    , mapper_CA22B , 0, NULL                },
	{ "cawingb"     , CPS_B_16    , mapper_CA24B , 0, NULL                },
	{ "cps1demo"    , CPS_B_04    , mapper_sfzch , 0, NULL                },
	{ "cworld2j"    , CPS_B_21_BT6, mapper_Q522B , 0, NULL                },
	{ "dino"        , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinou"       , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinoj"       , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinopic"     , CPS_B_21_QS2, mapper_CD63B , 0, NULL                },
	{ "dinopic2"    , CPS_B_21_QS2, mapper_CD63B , 0, NULL                },
	{ "dinoeh"      , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dinoh"       , CPS_B_21_DEF, mapper_CD63B , 0, dino_decode         },
	{ "dinoha"      , CPS_B_21_DEF, mapper_CD63B , 0, dino_decode         },
	{ "dinohb"      , CPS_B_21_QS2, mapper_CD63B , 0, dino_decode         },
	{ "dynwar"      , CPS_B_02    , mapper_TK22B , 0, NULL                },
	{ "dynwara"     , CPS_B_02    , mapper_TK22B , 0, NULL                },
	{ "dynwarj"     , CPS_B_02    , mapper_TK22B , 0, NULL                },
	{ "ffight"      , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightu"     , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightua"    , CPS_B_01    , mapper_S224B , 0, NULL                },
	{ "ffightub"    , CPS_B_05    , mapper_S224B , 0, NULL                },
	{ "ffightj"     , CPS_B_04    , mapper_S224B , 0, NULL                },
	{ "ffightj2"    , CPS_B_02    , mapper_S224B , 0, NULL                },
	{ "ffightj1"    , CPS_B_01    , mapper_S224B , 0, NULL                },
	{ "ffightjh"     , CPS_B_01    , mapper_S224B , 0, NULL                },
	{ "forgottn"    , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "forgottnu"   , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "lostwrld"    , CPS_B_01    , mapper_LWCHR , 1, NULL                },
	{ "ghouls"      , CPS_B_01    , mapper_DM620 , 0, NULL                },
	{ "ghoulsu"     , CPS_B_01    , mapper_DM620 , 0, NULL                },
	{ "daimakai"    , CPS_B_01    , mapper_DM22A , 0, NULL                },
	{ "daimakair"   , CPS_B_21_DEF, mapper_DAM63B, 0, NULL                },
	{ "daimakb"     , CPS_B_01    , mapper_DM620 , 0, NULL                },
	{ "knights"     , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsu"    , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsj"    , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsb2"   , CPS_B_21_BT4, mapper_KR63B , 0, NULL                },
	{ "knightsh"    , CPS_B_21_DEF, mapper_KR63B , 0, NULL                },
	{ "knghtsha"    , CPS_B_21_DEF, mapper_KR63B , 0, NULL                },
	{ "kod"         , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodu"        , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodj"        , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodb"        , CPS_B_21_BT2, mapper_KD29B , 0, NULL                },
	{ "kodh"        , CPS_B_21_DEF, mapper_KD29B , 0, NULL                },
	{ "megaman"     , CPS_B_21_DEF, mapper_RCM63B, 0, NULL                },
	{ "rockmanj"    , CPS_B_21_DEF, mapper_RCM63B, 0, NULL                },
	{ "mercs"       , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "mercsu"      , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "mercsua"     , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "mercsj"      , CPS_B_12    , mapper_O224B , 0, NULL                },
	{ "msword"      , CPS_B_13    , mapper_MS24B , 0, NULL                },
	{ "mswordr1"    , CPS_B_13    , mapper_MS24B , 0, NULL                },
	{ "mswordu"     , CPS_B_13    , mapper_MS24B , 0, NULL                },
	{ "mswordj"     , CPS_B_13    , mapper_MS24B , 0, NULL                },
	{ "mtwins"      , CPS_B_14    , mapper_CK24B , 0, NULL                },
	{ "chikij"      , CPS_B_14    , mapper_CK24B , 0, NULL                },
	{ "nemo"        , CPS_B_15    , mapper_NM24B , 0, NULL                },
	{ "nemoj"       , CPS_B_15    , mapper_NM24B , 0, NULL                },
	{ "pang3"       , CPS_B_21_DEF, mapper_pang3 , 0, NULL                },
	{ "pang3n"      , CPS_B_21_DEF, mapper_pang3 , 0, NULL                },
	{ "pang3j"      , CPS_B_21_DEF, mapper_pang3 , 0, NULL                },
	{ "pnickj"      , CPS_B_21_DEF, mapper_pnickj, 0, NULL                },
	{ "punisher"    , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "punisheru"   , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "punisherj"   , CPS_B_21_QS3, mapper_PS63B , 0, punisher_decode     },
	{ "punipic"     , CPS_B_21_QS3, mapper_PS63B , 0, NULL                },
	{ "punipic2"    , CPS_B_21_QS3, mapper_PS63B , 0, NULL                },
	{ "punipic3"    , CPS_B_21_QS3, mapper_PS63B , 0, NULL                },
	{ "qad"         , CPS_B_21_BT7, mapper_QD22B , 0, NULL                },
	{ "qadj"        , CPS_B_21_DEF, mapper_qadj  , 0, NULL                },
	{ "qtono2"      , CPS_B_21_DEF, mapper_qtono2, 0, NULL                },
	{ "sf2"         , CPS_B_11    , mapper_STF29 , 0, NULL                },
	{ "sf2eb"       , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ee"       , CPS_B_17    , mapper_STF29 , 0, NULL                },	
	{ "sf2ebbl"     , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ua"       , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ub"       , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2ud"       , CPS_B_05    , mapper_STF29 , 0, NULL                },
	{ "sf2ue"       , CPS_B_18    , mapper_STF29 , 0, NULL                },
	{ "sf2uf"       , CPS_B_15    , mapper_STF29 , 0, NULL                },
	{ "sf2ui"       , CPS_B_14    , mapper_STF29 , 0, NULL                },
	{ "sf2uk"       , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2j"        , CPS_B_13    , mapper_STF29 , 0, NULL                },
	{ "sf2ja"       , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2jc"       , CPS_B_12    , mapper_STF29 , 0, NULL                },
	{ "sf2qp1"      , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2b"        , CPS_B_17    , mapper_STF29 , 0, NULL                },
	{ "sf2thndr"    , CPS_B_17    , mapper_STF29 , 0, NULL                },	
	{ "sf2ce"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceea"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },	
	{ "sf2ceua"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceub"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2ceuc"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2cej"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2rb"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2rb2"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2rb3"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2red"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2v004"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2acc"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2accp2"    , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2dkot2"    , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2m1"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2m2"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2m3"       , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2m4"       , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2m5"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2m6"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2m7"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2m8"       , HACK_B_2    , mapper_S9263B, 0, NULL                },
	{ "sf2m9"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2m10"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2m11"      , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2m12"      , HACK_B_1    , mapper_S9263B, 0, NULL                },
	{ "sf2m13"      , HACK_B_4    , mapper_S9263B, 0, NULL                },
	{ "sf2tlona"    , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2tlonb"    , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2th"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2yyc"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2koryu"    , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2hf"       , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2hfu"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2hfj"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "slammast"    , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },
	{ "slammastu"   , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },
	{ "mbomberj"    , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },
	{ "mbombrd"     , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },
	{ "mbombrdj"    , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },
	{ "strider"     , CPS_B_01    , mapper_ST24M1, 1, NULL                },
	{ "striderua"   , CPS_B_01    , mapper_ST24M1, 1, NULL                },
	{ "striderjr"   , CPS_B_01    , mapper_ST24M1, 1, NULL                },
	{ "striderj"    , CPS_B_01    , mapper_ST22B , 1, NULL                },
	{ "unsquad"     , CPS_B_11    , mapper_AR24B , 0, NULL                },
	{ "area88r"     , CPS_B_11    , mapper_AR22B , 0, NULL                },	
	{ "area88"      , CPS_B_11    , mapper_AR22B , 0, NULL                },
	{ "varth"       , CPS_B_04    , mapper_VA63B , 0, NULL                },
	{ "varthr1"     , CPS_B_04    , mapper_VA63B , 0, NULL                },
	{ "varthu"      , CPS_B_04    , mapper_VA63B , 0, NULL                },
	{ "varthj"      , CPS_B_21_BT5, mapper_VA63B , 0, NULL                },
	{ "willow"      , CPS_B_03    , mapper_WL24B , 0, NULL                },
	{ "willowj"     , CPS_B_03    , mapper_WL24B , 0, NULL                },
	{ "willowje"    , CPS_B_03    , mapper_WL24B , 0, NULL                },
	{ "wof"         , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wofa"        , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wofu"        , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofj"        , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofhfh"      , CPS_B_21_DEF, mapper_TK263B, 0, NULL                },
	{ "wofb"        , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wof3js"      , CPS_B_21_DEF, mapper_TK263B, 0, NULL                },
	{ "wof3sj"      , HACK_B_3    , mapper_TK263B, 0, wof_decode          },
	{ "wof3sja"     , HACK_B_3    , mapper_TK263B, 0, wof_decode          },
	{ "wofaha"      , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wofah"       , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "wofh"        , HACK_B_3    , mapper_TK263B, 0, wof_decode          },	
	{ "wofha"       , HACK_B_3    , mapper_TK263B, 0, wof_decode          },
	{ "wofjh"       , CPS_B_21_QS1, mapper_TK263B, 0, wof_decode          },
	{ "wofsj"       , HACK_B_3    , mapper_TK263B, 0, wof_decode          },
	{ "wofsja"      , HACK_B_3    , mapper_TK263B, 0, wof_decode          },
	{ "wofsjb"      , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },
	{ "sfzch"       , CPS_B_21_DEF, mapper_sfzch , 0, NULL                },
	{ "wofch"       , CPS_B_21_DEF, mapper_sfzch , 0, wof_decode          },
	{ "cps1frog"    , CPS_B_04    , mapper_frog  , 0, NULL                },
	
	// Not included games
/*
	{ "pnicku"      , CPS_B_21_DEF, mapper_pnickj, 0, NULL                },	// IPS
	{ "sf2cebr"     , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },	// IPS
	{ "sf2ceh"      , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },	// IPS
	{ "slammasa"    , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "slammash"    , CPS_B_21_QS4, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "mbombdje"    , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "mbombrda"    , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "mbombrdh"    , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "mbombrdu"    , CPS_B_21_QS5, mapper_MB63B , 0, slammast_decode     },	// IPS
	{ "woffr"       , CPS_B_21_DEF, mapper_TK263B, 0, wof_decode          },	// IPS
	{ "sfach"       , CPS_B_21_DEF, mapper_sfzch , 0, NULL                },
	{ "sfzbch"      , CPS_B_21_DEF, mapper_sfzch , 0, NULL                },
*/

#if defined INCLUDE_DUPLICATES
	{ "dinob"       , CPS_B_21_QS2, mapper_CD63B , 0, NULL                },
	{ "kl2d"        , CPS_B_21_DEF, mapper_CD63B , 0, dino_decode         },
	{ "sf2tlonc"    , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2turyu"    , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
	{ "sf2tury2"    , CPS_B_21_DEF, mapper_S9263B, 0, NULL                },
#endif

	{ 0         , 0           , 0            , 0, 0                   }
};

static void SetGameConfig()
{
	const char *GameName = BurnDrvGetTextA(DRV_NAME);
	const struct GameConfig *k = &ConfigTable[0];

	while (k->DriverName) {
		if (strcmp(k->DriverName, GameName) == 0) {
			break;
		}
		++k;
	}

	if (k->DriverName) {
		GameHasStars = k->CpsStars;
		SetCpsBId(k->CpsBId, GameHasStars);
		SetGfxMapper(k->CpsMapperId);
		KabukiDecodeFunction = k->DecodeFunction;
	} else {
#if 1 && defined FBA_DEBUG
		bprintf(PRINT_IMPORTANT, _T("Missing Config Data\n"));
#endif
	}
}

// Driver functions

static unsigned int nCps68KByteswapRomNum = 0;
static unsigned int nCps68KNoByteswapRomNum = 0;
static unsigned int nCpsZ80RomNum = 0;
static unsigned int nCpsTilesRomNum = 0;
static unsigned int nCpsOkim6295RomNum = 0;
static unsigned int nCpsQsoundRomNum = 0;
static unsigned int nCpsPicRomNum = 0;

static int Cps1LoadRoms(int bLoad)
{
	struct BurnRomInfo ri;
	ri.nType = 0;
	ri.nLen = 0;
	int nOffset = -1;
	unsigned int i = 0;
	int nRet = 0;
	
	if (!bLoad) {
		do {
			ri.nLen = 0;
			ri.nType = 0;
			BurnDrvGetRomInfo(&ri, ++nOffset);
			if ((ri.nType & 0xff) == CPS1_68K_PROGRAM_BYTESWAP) {
				nCpsRomLen += ri.nLen;
				nCps68KByteswapRomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_68K_PROGRAM_NO_BYTESWAP) {
				nCpsRomLen += ri.nLen;
				nCps68KNoByteswapRomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_Z80_PROGRAM) {
				nCpsZRomLen += ri.nLen;
				nCpsZ80RomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_TILES) {
				nCpsGfxLen += ri.nLen;
				nCpsTilesRomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_PIC) {
				nCpsPicRomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_OKIM6295_SAMPLES) {
				nCpsAdLen += ri.nLen;
				nCpsOkim6295RomNum++;
			}
			if ((ri.nType & 0xff) == CPS1_QSOUND_SAMPLES) {
				Cps1Qs = 1;
				nCpsQSamLen += ri.nLen;
				nCpsQsoundRomNum++;
			}
			i++;
			
		} while (ri.nLen);
		
		if (Cps1Qs) nCpsZRomLen *= 2;
		if (GameHasStars) nCpsGfxLen += 0x2000;
		if (PangEEP) nCpsGfxLen *= 2;
		if (nCpsPicRomNum) Cps1Pic = 1;
		
#if 1 && defined FBA_DEBUG
		if (nCpsRomLen) bprintf(PRINT_IMPORTANT, _T("68K Rom Length %06X, (%i roms byteswapped, %i roms not byteswapped)\n"), nCpsRomLen, nCps68KByteswapRomNum, nCps68KNoByteswapRomNum);
		if (nCpsZRomLen) bprintf(PRINT_IMPORTANT, _T("Z80 Rom Length %06X, (%i roms)\n"), nCpsZRomLen, nCpsZ80RomNum);
		if (nCpsGfxLen) bprintf(PRINT_IMPORTANT, _T("Tile Rom Length %08X, (%i roms)\n"), nCpsGfxLen, nCpsTilesRomNum);
		if (nCpsAdLen) bprintf(PRINT_IMPORTANT, _T("OKIM6295 Rom Length %08X, (%i roms)\n"), nCpsAdLen, nCpsOkim6295RomNum);
		if (nCpsQSamLen) bprintf(PRINT_IMPORTANT, _T("QSound Rom Length %08X, (%i roms)\n"), nCpsQSamLen, nCpsQsoundRomNum);
#endif
	}

	if (bLoad) {
		int Offset = 0;
		
		i = 0;
		while (i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum) {
			BurnDrvGetRomInfo(&ri, i + 0);
			if ((ri.nType & 0xff) == CPS1_68K_PROGRAM_BYTESWAP) {
				nRet = BurnLoadRom(CpsRom + Offset + 1, i + 0, 2); if (nRet) return 1;
				nRet = BurnLoadRom(CpsRom + Offset + 0, i + 1, 2); if (nRet) return 1;
			
				BurnDrvGetRomInfo(&ri, i + 0);
				Offset += ri.nLen;
				BurnDrvGetRomInfo(&ri, i + 1);
				Offset += ri.nLen;
				
				i += 2;
			}
			
			if ((ri.nType & 0xff) == CPS1_68K_PROGRAM_NO_BYTESWAP) {
				nRet = BurnLoadRom(CpsRom + Offset, i, 1); if (nRet) return 1;
			
				BurnDrvGetRomInfo(&ri, i);
				Offset += ri.nLen;
				
				i++;
			}
		}
		
		// Graphics
		if (nCpsGfxLen) {
			Offset = 0;
			i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum;
			while (i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum) {
				if (ForgottnAltGfx) {
					CpsLoadTilesForgottnAlt(CpsGfx, i);
				
					i += nCpsTilesRomNum;
				} else {
					BurnDrvGetRomInfo(&ri, i + 0);

					if (ri.nLen < 0x80000) {
						CpsLoadTilesByte(CpsGfx + Offset, i);
		
						BurnDrvGetRomInfo(&ri, i + 0);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 1);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 2);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 3);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 4);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 5);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 6);
						Offset += ri.nLen;
						BurnDrvGetRomInfo(&ri, i + 7);
						Offset += ri.nLen;
						
						i += 8;
					} else {
						if (PangEEP) {
							CpsLoadTilesPang(CpsGfx + Offset, i);
			
							BurnDrvGetRomInfo(&ri, i + 0);
							Offset += ri.nLen;
							BurnDrvGetRomInfo(&ri, i + 1);
							Offset += ri.nLen;
							BurnDrvGetRomInfo(&ri, i + 2);
							Offset += ri.nLen;
							BurnDrvGetRomInfo(&ri, i + 3);
							Offset += ri.nLen;
					
							i += 4;
						} else {
							if (nCpsTilesRomNum < 4) {
								// Handle this seperately
								i += nCpsTilesRomNum;
							} else {
								CpsLoadTiles(CpsGfx + Offset, i);
					
								BurnDrvGetRomInfo(&ri, i + 0);
								Offset += ri.nLen;
								BurnDrvGetRomInfo(&ri, i + 1);
								Offset += ri.nLen;
								BurnDrvGetRomInfo(&ri, i + 2);
								Offset += ri.nLen;
								BurnDrvGetRomInfo(&ri, i + 3);
								Offset += ri.nLen;
				
								i += 4;
							}
						}
					}
				}
			}			
		}
		
		// Z80 Program
		if (nCpsZRomLen) {
			Offset = 0;
			for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i++) {
				BurnLoadRom(CpsZRom + Offset, i, 1);
				
				if (Cps1Qs) BurnLoadRom(CpsEncZRom + Offset, i, 1);
			
				BurnDrvGetRomInfo(&ri, i);
				Offset += ri.nLen;
			}
		}
		
		// Pic (skip for now)
		if (nCpsPicRomNum) {
			BurnDrvGetRomInfo(&ri, i);
		}
		
		// OKIM6295 Samples
		if (nCpsAdLen) {
			Offset = 0;
			for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum + nCpsOkim6295RomNum; i++) {
				BurnLoadRom(CpsAd + Offset, i, 1);
			
				BurnDrvGetRomInfo(&ri, i);
				Offset += ri.nLen;
			}
		}
		
		// QSound Samples
		if (nCpsQSamLen) {
			Offset = 0;
			for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum + nCpsQsoundRomNum; i++) {
				BurnLoadRom((unsigned char*)CpsQSam + Offset, i, 1);
			
				BurnDrvGetRomInfo(&ri, i);
				Offset += ri.nLen;
			}
		}
	}

	return nRet;
}

typedef void (*AmendProgRom)();
static AmendProgRom AmendProgRomCallback;

static int DrvInit()
{
	int nRet = 0;
	
	SetGameConfig();
    
	Cps1LoadRoms(0);

	Cps = 1;
	nRet = CpsInit(); if (nRet != 0) return 1;
	
	Cps1LoadRoms(1);
	
	if (AmendProgRomCallback) AmendProgRomCallback();
	
	SetGameConfig();
	
	if (Cps1Qs) {
		KabukiDecodeFunction();
	}
	
	nRet = CpsRunInit(); if (nRet != 0) return 1;
	
	return 0;
}

static int TwelveMhzInit()
{
	nCPS68KClockspeed = 12000000;
	
	return DrvInit();
}

static int CaptcommbInit()
{
	int nRet = 0;
	
	CpsLayer1XOffs = -8;
	CpsLayer2XOffs = -11;
	CpsLayer3XOffs = -12;
	
	nRet = DrvInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesCaptcomb(CpsGfx, 4);
	
	return nRet;
}

unsigned char __fastcall CawingbInputRead(unsigned int a)
{
	unsigned char d = 0xff;
	
	switch (a) {
		case 0x882000: {
			d = (unsigned char)~Inp000;
			return d;
		}
		
		case 0x882001: {
			d = (unsigned char)~Inp001;
			return d;
		}
		
		case 0x882008: {
			d = (unsigned char)~Inp008;
			return d;
		}
		
		case 0x88200a: {
			d = (unsigned char)~Cpi01A;
			return d;
		}
		
		case 0x88200c: {
			d = (unsigned char)~Cpi01C;
			return d;
		}
		
		case 0x88200e: {
			d = (unsigned char)~Cpi01E;
			return d;
		}
	}

	return 0;
}

void __fastcall CawingbInputWrite(unsigned int a, unsigned char d)
{
	switch (a) {
		case 0x882006: {
			PsndSyncZ80((long long)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);
			
			PsndCode = d;
			return;
		}
	}

}

static int CawingbInit()
{
	int nRet = 0;
	
	CpsLayer1XOffs = 0xffc0;
//	CpsLayer2XOffs = 0xffc0;
//	CpsLayer3XOffs = 0xffc0;
	
	nRet = DrvInit();
	
	SekOpen(0);
	SekMapHandler(1, 0x882000, 0x88200f, SM_RAM);
	SekSetReadByteHandler(1, CawingbInputRead);
	SekSetWriteByteHandler(1, CawingbInputWrite);
	SekClose();
	
	return 0;
}

void __fastcall DinopicScrollWrite(unsigned int a, unsigned short d)
{
	if (a == 0x980000) {
		CpsLayer1YOffs = d;
		return;
	}
	
	if (a == 0x980002) {
		CpsLayer1XOffs = d - 0x40;
		return;
	}
	
	if (a == 0x980004) {
		CpsLayer2YOffs = d;
		return;
	}
	
	if (a == 0x980006) {
		CpsLayer2XOffs = d - 0x40;
		return;
	}
	
	if (a == 0x980008) {
		CpsLayer3YOffs = d;
		return;
	}
	
	if (a == 0x98000a) {
		CpsLayer3XOffs = d - 0x40;
		return;
	}
}

static int DinopicInit()
{
	int nRet = 0;
	
	Dinopic = 1;
	CpsDrawSpritesInReverse = 1;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesBootleg(CpsGfx + 0x000000, 4);
	CpsLoadTilesBootleg(CpsGfx + 0x200000, 8);
	
	BootlegSpriteRam = (unsigned char*)osd_malloc(0x2000);
	
	SekOpen(0);
	SekMapMemory(BootlegSpriteRam, 0x990000, 0x991FFF, SM_RAM);
	SekMapHandler(1, 0x980000, 0x98000b, SM_WRITE);
	SekSetWriteWordHandler(1, DinopicScrollWrite);
	SekClose();
	
	return nRet;
}

static void DinohCallback()
{
	// Patch Q-Sound Test ???
	*((unsigned short*)(CpsRom + 0xaacf4)) = 0x4e71;
}

static int DinohInit()
{
	Cps1QsHack = 1;
	AmendProgRomCallback = DinohCallback;
	
	return TwelveMhzInit();
}

static void DinohaCallback()
{
	unsigned char *TempRom = (unsigned char*)osd_malloc(0x200000);
	if (TempRom) {
		memcpy(TempRom, CpsRom, 0x200000);
		memset(CpsRom, 0, 0x200000);
		memcpy(CpsRom + 0x080000, TempRom + 0x000000, 0x80000);
		memcpy(CpsRom + 0x000000, TempRom + 0x080000, 0x80000);
		memcpy(CpsRom + 0x180000, TempRom + 0x100000, 0x80000);
		memcpy(CpsRom + 0x100000, TempRom + 0x180000, 0x80000);
		free(TempRom);
	}
	
	// Patch Q-Sound Test ???
	*((unsigned short*)(CpsRom + 0xaacf4)) = 0x4e71;
}

static int DinohaInit()
{
	int nRet = 0;
	
	Cps1QsHack = 1;
	AmendProgRomCallback = DinohaCallback;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesHack160(CpsGfx, 2);
	
	return nRet;
}

static int DinohbInit()
{
	int nRet = 0;
	
	Dinopic = 1;
	Cps1Pic = 1;
	CpsDrawSpritesInReverse = 1;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesHack160(CpsGfx, 2);
	
	BootlegSpriteRam = (unsigned char*)osd_malloc(0x2000);
	
	SekOpen(0);
	SekMapMemory(BootlegSpriteRam, 0x990000, 0x991FFF, SM_RAM);
	SekMapHandler(1, 0x980000, 0x98000b, SM_WRITE);
	SekSetWriteWordHandler(1, DinopicScrollWrite);
	SekClose();
	
	return nRet;
}

static int ForgottnInit()
{
	int nRet = 0;
	
	Forgottn = 1;

	nRet = DrvInit();
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStars(CpsStar, 9);
	
	return nRet;
}

static int ForgottnAltGfxInit()
{
	int nRet = 0;
	
	Forgottn = 1;
	ForgottnAltGfx = 1;

	nRet = DrvInit();
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStarsForgottnAlt(CpsStar, 15);
	
	return nRet;
}

static void GhoulsCallback()
{
	BurnByteswap(CpsRom + 0x080000, 0x080000);
}

static int GhoulsInit()
{
	Ghouls = 1;
	AmendProgRomCallback = GhoulsCallback;

	return DrvInit();
}

static int DaimakaiInit()
{
	Ghouls = 1;
	
	return DrvInit();
}

static int DaimakbInit()
{
	Ghouls = 1;
	Port6SoundWrite = 1;	
	
	return DrvInit();
}

static int KodbInit()
{
	int nRet = 0;

	Kodb = 1;
	
	nRet = DrvInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesByte(CpsGfx, 2);

	return nRet;
}

static int KodhInit()
{
	Kodh = 1;
	
	return DrvInit();
}

static int MercsInit()
{
	Mercs = 1;

	return DrvInit();
}

static int Pang3nInit()
{
	PangEEP = 1;

	return TwelveMhzInit();
}

static void Pang3Callback()
{
	for (int i = 0x80000; i < 0x100000; i += 2) {
		int src = CpsRom[i];
		int dst = src & 0xff00;
		if ( src & 0x01) dst ^= 0x04;
		if ( src & 0x02) dst ^= 0x21;
		if ( src & 0x04) dst ^= 0x01;
		if (~src & 0x08) dst ^= 0x50;
		if ( src & 0x10) dst ^= 0x40;
		if ( src & 0x20) dst ^= 0x06;
		if ( src & 0x40) dst ^= 0x08;
		if (~src & 0x80) dst ^= 0x88;
		CpsRom[i] = (unsigned char)dst;
  	}
}

static int Pang3Init()
{
	AmendProgRomCallback = Pang3Callback;
	
	return Pang3nInit();
}

static int PunipicInit()
{
	int nRet = 0;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesBootleg(CpsGfx + 0x000000, 4);
	CpsLoadTilesBootleg(CpsGfx + 0x200000, 8);
	
	return nRet;
}

static int Punipic2Init()
{
	int nRet = 0;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesPunipic2(CpsGfx, 4);
	
	return nRet;
}

static int Punipic3Init()
{
	int nRet = 0;
	
	Cps1Pic = 1;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesHack160(CpsGfx, 4);
	
	return nRet;
}

static int QadInit()
{
	Qad = 1;

	return TwelveMhzInit();
}

static int Sf2ebblInit()
{
	int nRet = DrvInit();
	
	memset(CpsGfx + 0x400000, 0, 0x80000);
	CpsLoadTilesSf2ebbl(CpsGfx + 0x400000, 19);
	
	Sf2Hack = 1;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return nRet;
}

static int Sf2jcInit()
{
	Sf2jc = 1;

	return DrvInit();
}

static void Sf2qp1Callback()
{
	unsigned char *TempRom = (unsigned char*)osd_malloc(0x100000);
	if (TempRom) {
		memcpy(TempRom, CpsRom, 0x100000);
		memset(CpsRom, 0, 0x100000);
		memcpy(CpsRom + 0x000000, TempRom + 0x000000, 0x40000);
		memcpy(CpsRom + 0x0c0000, TempRom + 0x040000, 0x40000);
		memcpy(CpsRom + 0x080000, TempRom + 0x080000, 0x40000);
		memcpy(CpsRom + 0x040000, TempRom + 0x0c0000, 0x40000);
		free(TempRom);
	}
}

static int Sf2qp1Init()
{
	AmendProgRomCallback = Sf2qp1Callback;
	
	return DrvInit();
}

static int Sf2ceInit()
{
	nCPS68KClockspeed = 7000000;
	
	return DrvInit();
}

static void Sf2accp2Callback()
{
	CpsRom[0x11755] = 0x4e;
	CpsRom[0x11756] = 0x71;
}

static int Sf2accp2Init()
{
	AmendProgRomCallback = Sf2accp2Callback;
	
	return Sf2ceInit();
}

static int Sf2dkot2Init()
{
	int nRet;

	nRet = Sf2ceInit();

	SekOpen(0);
	SekMapMemory(CpsRom + 0x000000, 0x280000, 0x2fffff, SM_ROM);
	SekMapMemory(CpsRom + 0x080000, 0x200000, 0x27ffff, SM_ROM);
	SekClose();

	return nRet;
}

static void Sf2rbCallback()
{
	BurnByteswap(CpsRom, 0x100000);
	CpsRom[0xe5465] = 0x60;
	CpsRom[0xe5464] = 0x12;
}

static int Sf2rbInit()
{
	AmendProgRomCallback = Sf2rbCallback;
	
	return Sf2ceInit();
}

static void Sf2rb2Callback()
{
	BurnByteswap(CpsRom, 0x100000);
	CpsRom[0xe5333] = 0x60;
	CpsRom[0xe5332] = 0x14;
}

static int Sf2rb2Init()
{
	AmendProgRomCallback = Sf2rb2Callback;
	
	return Sf2ceInit();
}

static int Sf2thInit()
{
	int nRet = 0;
	
	Sf2Hack = 1;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	nRet = Sf2ceInit();
	
	return nRet;
}

static void Sf2yycCallback()
{
	memcpy(CpsRom + 0x140000, CpsRom + 0x100000, 0x40000);
        
        *((unsigned short*)(CpsRom + 0xe55be)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55ca)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55cc)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55ce)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55d0)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55d2)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55d4)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55d6)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55d8)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55da)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55de)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55e2)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55e4)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55e6)) = 0x4e71;
	*((unsigned short*)(CpsRom + 0xe55e8)) = 0x4e71;
}

static int Sf2yycInit()
{
	nCpsRomLen = 0x40000;
	
	Sf2Hack = 1;
	AmendProgRomCallback = Sf2yycCallback;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return Sf2ceInit();
}

static void Sf2koryuCallback()
{
	BurnByteswap(CpsRom, 0x140000);
}

static int Sf2koryuInit()
{
	Sf2Hack = 1;
	AmendProgRomCallback = Sf2koryuCallback;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return Sf2ceInit();
}

static int Sf2m4Init()
{
	Sf2Hack = 1;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return Sf2ceInit();
}

void __fastcall Sf2m1ScrollWrite(unsigned int a, unsigned short d)
{
	if (a == 0x980000) {
		CpsReg[0x0e] = d & 0xff;
		CpsReg[0x0f] = d >> 8;
		return;
	}
	
	if (a == 0x980002) {
		d -= 0x40;
		CpsReg[0x0c] = d & 0xff;
		CpsReg[0x0d] = d >> 8;
		return;
	}
	
	if (a == 0x980004) {
		CpsReg[0x12] = d & 0xff;
		CpsReg[0x13] = d >> 8;
		return;
	}
	
	if (a == 0x980006) {
		d -= 0x40;
		CpsReg[0x10] = d & 0xff;
		CpsReg[0x11] = d >> 8;
		return;
	}
	
	if (a == 0x980008) {
		CpsReg[0x16] = d & 0xff;
		CpsReg[0x17] = d >> 8;
		return;
	}
	
	if (a == 0x98000a) {
		d -= 0x40;
		CpsReg[0x14] = d & 0xff;
		CpsReg[0x15] = d >> 8;
		return;
	}
	
	if (a == 0x980016) {
		CpsReg[0x06] = d & 0xff;
		CpsReg[0x07] = d >> 8;
		return;
	}
	
	if (a == 0x980166) {
		CpsReg[0x66] = d & 0xff;
		CpsReg[0x67] = d >> 8;
		return;
	}
}

static int Sf2m1Init()
{
	int nRet = 0;
	
	CpsLayer2XOffs = 4;
	Port6SoundWrite = 1;
	
	nRet = Sf2ceInit();
	
	SekOpen(0);
	SekMapHandler(1, 0x980000, 0x980167, SM_WRITE);
	SekSetWriteWordHandler(1, Sf2m1ScrollWrite);
	SekClose();
	
	return nRet;
}

static void Sf2m2Callback()
{
	*((unsigned short*)(CpsRom + 0xC0680)) = 0x4E71;
	*((unsigned short*)(CpsRom + 0xC0682)) = 0x4E71;
	*((unsigned short*)(CpsRom + 0xC0684)) = 0x4E71;
}

static int Sf2m2Init()
{
	Sf2Hack = 1;
	AmendProgRomCallback = Sf2m2Callback;
	
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	return Sf2ceInit();
}

unsigned char __fastcall Sf2m3ReadByte(unsigned int a)
{
	unsigned char d = 0xff;
	
	switch (a) {
		case 0x800010: {
			d = (unsigned char)~Inp010;
			return d;
		}
		
		case 0x800011: {
			d = (unsigned char)~Inp011;
			return d;
		}
		
		case 0x800029: {
			d = (unsigned char)~Inp029;
			return d;
		}
		
		case 0x800186: {
			d = (unsigned char)~Inp186;
			return d;
		}
		
		case 0x80002a: {
			d = (unsigned char)~Cpi01A;
			return d;
		}
		
		case 0x80002c: {
			d = (unsigned char)~Cpi01C;
			return d;
		}
		
		case 0x80002e: {
			d = (unsigned char)~Cpi01E;
			return d;
		}
	}
	
//	bprintf(PRINT_NORMAL, _T("Read byte %x\n"), a);
	
	return 0;
}

void __fastcall Sf2m3WriteByte(unsigned int a, unsigned char d)
{
	switch (a) {
		case 0x800191: {
			PsndSyncZ80((long long)SekTotalCycles() * nCpsZ80Cycles / nCpsCycles);

			PsndCode = d;
			return;
		}
	}
	
//	bprintf(PRINT_NORMAL, _T("Write byte %x, %x\n"), a, d);
}

void __fastcall Sf2m3WriteWord(unsigned int a, unsigned short d)
{
	switch (a) {
		case 0x800100: {
			CpsReg[0x00] = d & 0xff;
			CpsReg[0x01] = d >> 8;
			return;
		}
		
		case 0x800102: {
			CpsReg[0x02] = d & 0xff;
			CpsReg[0x03] = d >> 8;
			return;
		}
		
		case 0x800104: {
			CpsReg[0x04] = d & 0xff;
			CpsReg[0x05] = d >> 8;
			return;
		}
		
		case 0x800106: {
			CpsReg[0x06] = d & 0xff;
			CpsReg[0x07] = d >> 8;
			return;
		}
		
		case 0x80010a: {
			CpsReg[0x0a] = d & 0xff;
			CpsReg[0x0b] = d >> 8;
			return;
		}
		
		case 0x800122: {
			CpsReg[0x22] = d & 0xff;
			CpsReg[0x23] = d >> 8;
			return;
		}
		
		case 0x80014a: {
			CpsReg[0x4a] = d & 0xff;
			CpsReg[0x4b] = d >> 8;
			return;
		}
		
		case 0x80014c: {
			CpsReg[0x4c] = d & 0xff;
			CpsReg[0x4d] = d >> 8;
			return;
		}
		
		case 0x80014e: {
			CpsReg[0x4e] = d & 0xff;
			CpsReg[0x4f] = d >> 8;
			return;
		}
		
		case 0x800150: {
			CpsReg[0x50] = d & 0xff;
			CpsReg[0x51] = d >> 8;
			return;
		}
		
		case 0x800152: {
			CpsReg[0x52] = d & 0xff;
			CpsReg[0x53] = d >> 8;
			return;
		}
		
		case 0x8001a8: {
			CpsReg[0x08] = d & 0xff;
			CpsReg[0x09] = d >> 8;
			return;
		}
		
		case 0x8001ac: {
			CpsReg[0x0c] = d & 0xff;
			CpsReg[0x0d] = d >> 8;
			return;
		}
		
		case 0x8001ae: {
			CpsReg[0x0e] = d & 0xff;
			CpsReg[0x0f] = d >> 8;
			return;
		}
		
		case 0x8001b0: {
			CpsReg[0x10] = d & 0xff;
			CpsReg[0x11] = d >> 8;
			return;
		}
		
		case 0x8001b2: {
			CpsReg[0x12] = d & 0xff;
			CpsReg[0x13] = d >> 8;
			return;
		}
		
		case 0x8001b4: {
			CpsReg[0x14] = d & 0xff;
			CpsReg[0x15] = d >> 8;
			return;
		}
		
		case 0x8001b6: {
			CpsReg[0x16] = d & 0xff;
			CpsReg[0x17] = d >> 8;
			return;
		}
		
		case 0x8001c0: {
			CpsReg[0x20] = d & 0xff;
			CpsReg[0x21] = d >> 8;
			return;
		}	
		
		case 0x8001c4: {
			CpsReg[0xc4] = d & 0xff;
			CpsReg[0xc5] = d >> 8;
			return;
		}
	}
	
//	bprintf(PRINT_NORMAL, _T("Write word %x, %x\n"), a, d);
}

static int Sf2m3Init()
{
	int nRet = 0;
	
	CpsLayer1XOffs = -16;
	CpsLayer2XOffs = -16;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	nRet = Sf2ceInit();
	
	SekOpen(0);
	SekMapHandler(1, 0x800000, 0x800200, SM_RAM);
	SekSetReadByteHandler(1, Sf2m3ReadByte);
	SekSetWriteByteHandler(1, Sf2m3WriteByte);
	SekSetWriteWordHandler(1, Sf2m3WriteWord);
	
	SekClose();
	
	return nRet;
}

static int Sf2m8Init()
{
	Scroll1TileMask = 0x4fff;
	Scroll3TileMask = 0x1fff;
	
	return Sf2m3Init();
}

static void Sf2m13Callback()
{
	CpsRom[0x1d22a] = 0x20;	// Fix scroll
}

static int Sf2m13Init()
{
	CpsLayer1XOffs = -12;
	CpsLayer2XOffs = -14;
	CpsLayer3XOffs = -16;
	CpsDrawSpritesInReverse = 1;
	
	AmendProgRomCallback = Sf2m13Callback;
	
	return Sf2ceInit();
}

static int SfzchInit()
{
	int nRet = 0;
	
	nRet = DrvInit();
	
	Cps = 1;
	
	return nRet;
}

static int StriderInit()
{
	int nRet = 0;
	
	nRet = DrvInit();
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStars(CpsStar, 5);
	
	return nRet;
}

static int StriderjrInit()
{
	int nRet = 0;
	
	nRet = DrvInit();
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStars(CpsStar, 2);
	
	return nRet;
}

static int StriderjInit()
{
	int nRet = 0;
	
	nRet = DrvInit();
	
	CpsStar = CpsGfx + nCpsGfxLen - 0x2000;
	
	CpsLoadStarsByte(CpsStar, 8);
	
	return nRet;
}

static int WofbInit()
{
	int nRet = 0;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesBootleg(CpsGfx + 0x000000, 4);
	CpsLoadTilesBootleg(CpsGfx + 0x200000, 8);
	
	return nRet;	
}

static void Wof3jsCallback()
{
	memcpy(CpsRom + 0x0c0000, CpsRom + 0x100000, 0x40000);
	memset(CpsRom + 0x100000, 0, 0x40000);
}

static int Wof3jsInit()
{
	AmendProgRomCallback = Wof3jsCallback;
	
	return TwelveMhzInit();
}

static int Wof3sjInit()
{
	int nRet = 0;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesHack160(CpsGfx, 2);
	
	return nRet;
}

static int Wof3sjaInit()
{
	int nRet = 0;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesHack160(CpsGfx, 1);
	
	return nRet;
}

static int WofchInit()
{
	int nRet = 0;

	Cps1Qs = 1;
	
	nRet = DrvInit();
	
	Cps = 1;
	
	return nRet;
}

static void WofhCallback()
{
	// Patch protection? check
	CpsRom[0xf11ed] = 0x4e;
	CpsRom[0xf11ec] = 0x71;
	CpsRom[0xf11ef] = 0x4e;
	CpsRom[0xf11ee] = 0x71;
}

static int WofhInit()
{
	int nRet = 0;
	
	AmendProgRomCallback = WofhCallback;
	
	CpsLayer1XOffs = 0xffc0;
	CpsLayer2XOffs = 0xffc0;
	CpsLayer3XOffs = 0xffc0;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesHack160(CpsGfx, 1);
	
	return nRet;
}

static int WofhaInit()
{
	int nRet = 0;
	
	AmendProgRomCallback = WofhCallback;
	
	CpsLayer1XOffs = 0xffc0;
	CpsLayer2XOffs = 0xffc0;
	CpsLayer3XOffs = 0xffc0;
	
	nRet = TwelveMhzInit();
	
	memset(CpsGfx, 0, nCpsGfxLen);
	CpsLoadTilesHack160(CpsGfx, 2);
	
	return nRet;
}

static int DrvExit()
{
	CpsRunExit();
	CpsExit();
	
	nCpsRomLen = 0;
	nCpsZRomLen = 0;
	nCpsGfxLen = 0;
	nCpsAdLen = 0;
	nCpsQSamLen = 0;
	nCpsPicRomNum = 0;
	
	nCps68KByteswapRomNum = 0;
	nCps68KNoByteswapRomNum = 0;
	nCpsZ80RomNum = 0;
	nCpsTilesRomNum = 0;
	nCpsOkim6295RomNum = 0;
	nCpsQsoundRomNum = 0;
	KabukiDecodeFunction = NULL;
	GameHasStars = 0;
	
	AmendProgRomCallback = NULL;
	
	CpsLayer1XOffs = 0;
	CpsLayer2XOffs = 0;
	CpsLayer3XOffs = 0;
	CpsLayer1YOffs = 0;
	CpsLayer2YOffs = 0;
	CpsLayer3YOffs = 0;
	CpsDrawSpritesInReverse = 0;

	Cps = 0;
	Cps1Qs = 0;
	Cps1Pic = 0;
	Forgottn = 0;
	ForgottnAltGfx = 0;
	Ghouls = 0;
	Kodb = 0;
	Mercs = 0;
	PangEEP = 0;
	Qad = 0;
	Sf2jc = 0;
	Sf2Hack = 0;
	Dinopic = 0;
	Port6SoundWrite = 0;
	
	Cps1QsHack = 0;
	
	free(BootlegSpriteRam);
	BootlegSpriteRam = NULL;
	
	return 0;
}

// Jukebox support

static int DrvJukeboxDoReset()
{
	ZetOpen(0);
	ZetReset();
	ZetClose();
	
	if (Cps1Qs) {
		QsndReset();
	} else {
		PsndCode = 0;
	}
	
	return 0;
}

static int DrvJukeboxInit()
{
	struct BurnRomInfo ri;
	ri.nType = 0;
	ri.nLen = 0;
	unsigned int i = 0;
	int Offset;
	
	Cps = 1;
	
	Cps1LoadRoms(0);
	
	CpsZRom = (unsigned char*)osd_malloc(nCpsZRomLen);
	CpsAd = (unsigned char*)osd_malloc(nCpsAdLen);
	CpsQSam = (char*)osd_malloc(nCpsQSamLen);
	
	if (Cps1Qs) {
		CpsZRamC0 = (unsigned char*)osd_malloc(0x1000);
		CpsZRamF0 = (unsigned char*)osd_malloc(0x1000);
		memset(CpsZRamC0, 0xff, 0x1000);
//		memset(CpsZRamF0, 0xff, 0x1000);
	}
	
	Offset = 0;
	for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i++) {
		BurnLoadRom(CpsZRom + Offset, i, 1);
				
//		if (Cps1Qs) BurnLoadRom(CpsEncZRom + Offset, i, 1);
			
		BurnDrvGetRomInfo(&ri, i);
		Offset += ri.nLen;
	}
	
	if (nCpsAdLen) {
		Offset = 0;
		for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum + nCpsOkim6295RomNum; i++) {
			BurnLoadRom(CpsAd + Offset, i, 1);
			
			BurnDrvGetRomInfo(&ri, i);
			Offset += ri.nLen;
		}
	}
	
	if (nCpsQSamLen) {
		Offset = 0;
		for (i = nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum; i < nCps68KByteswapRomNum + nCps68KNoByteswapRomNum + nCpsTilesRomNum + nCpsZ80RomNum + nCpsQsoundRomNum; i++) {
			BurnLoadRom((unsigned char*)CpsQSam + Offset, i, 1);		
			BurnDrvGetRomInfo(&ri, i);
			Offset += ri.nLen;
		}
	}
	
	if (Cps1Qs) {
		dino_decode();
		if (QsndInit()) return 1;
	} else {
		if (PsndInit()) return 1;
	}
	
//	QsndReset();
	
	DrvJukeboxDoReset();
	
	return 0;
}

static int DrvJukeboxExit()
{
	return DrvExit();
}

static int DrvJukeboxFrame()
{
	if (JukeboxSoundCommand == JUKEBOX_SOUND_STOP) {
		DrvJukeboxDoReset();
		
		JukeboxSoundCommand = JUKEBOX_SOUND_NULL;
	}

	if (JukeboxSoundCommand == JUKEBOX_SOUND_PLAY) {
		DrvJukeboxDoReset();
		
		if (Cps1Qs) {
			CpsZRamC0[0x00] = JukeboxSoundLatch >> 8;
			CpsZRamC0[0x01] = JukeboxSoundLatch & 0xff;
			
			// are all of these writes necessary? [seems like they are]
			CpsZRamC0[0x02] = 0xFF;
			CpsZRamC0[0x03] = 0x00;
			CpsZRamC0[0x04] = 0x00;
			CpsZRamC0[0x06] = 0x00;
			CpsZRamC0[0x07] = 0x10;
			CpsZRamC0[0x08] = 0x00;
			CpsZRamC0[0x09] = 0x00;
			CpsZRamC0[0x0A] = 0x00;
			CpsZRamC0[0x0B] = 0x00;
			CpsZRamC0[0x0C] = 0x00;
//			CpsZRamC0[0x0D] = 0x00;
//			CpsZRamC0[0x0E] = 0x00;
			CpsZRamC0[0x0F] = 0x00;
		} else {
			PsndCode = JukeboxSoundLatch;
		}
		
		JukeboxSoundCommand = JUKEBOX_SOUND_NULL;
	}
	
	if (Cps1Qs) {
		QsndNewFrame();	
		QsndEndFrame();
	} else {
		ZetOpen(0);
		PsndNewFrame();
		PsndSyncZ80(nCpsZ80Cycles);
		PsmUpdate(nBurnSoundLen);
		ZetClose();
	}
	
	return 0;
}

void Cps1SoundStop() {
	DrvJukeboxDoReset();
}

// Driver Definitions

struct BurnDriver BurnDrvCpsCaptcommj = {
	"captcommj", NULL, NULL, "1991",
	"Captain Commando (Japan 911202)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 4, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, CaptcommjRomInfo, CaptcommjRomName, CaptcommInputInfo, CaptcommDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsCworld2j = {
	"cworld2j", NULL, NULL, "1992",
	"Adventure Quiz Capcom World 2 (Japan 920611)\0", NULL, "Capcom", "CPS Changer",
	L"Capcom World 2 (Japan 920611)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPS1, GBF_PUZZLE, 0,
	NULL, Cworld2jRomInfo, Cworld2jRomName, Cworld2jInputInfo, Cworld2jDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsDinoj = {
	"dinoj", NULL, NULL, "1993",
	"Cadillacs: Kyouryuu Shin Seiki (Japan 930201)\0", NULL, "Capcom", "CPS1 / QSound",
	L"Cadillacs \u6050\u7ADC\u65B0\u4E16\u7D00 (Japan 930201)\0Cadillacs Kyouryuu-Shinseiki (Japan 930201)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinojRomInfo, DinojRomName, DinoInputInfo, DinoDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsFfightj = {
	"ffightj", NULL, NULL, "1989",
	"Final Fight (Japan)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, FfightjRomInfo, FfightjRomName, FfightInputInfo, FfightDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKnightsj = {
	"knightsj", NULL, NULL, "1991",
	"Knights of the Round (Japan 911127)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KnightsjRomInfo, KnightsjRomName, KnightsInputInfo, KnightsDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsKodj = {
	"kodj", NULL, NULL, "1991",
	"The King of Dragons (Japan 910805)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 3, HARDWARE_CAPCOM_CPS1, GBF_SCRFIGHT, 0,
	NULL, KodjRomInfo, KodjRomName, KodInputInfo, KodjDIPInfo,
	DrvInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsPunisherj = {
	"punisherj", NULL, NULL, "1993",
	"The Punisher (Japan 930422)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, PunisherjRomInfo, PunisherjRomName, PunisherInputInfo, PunisherDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSf2hfj = {
	"sf2hfj", NULL, NULL, "1992",
	"Street Fighter II' Turbo: Hyper Fighting (Japan 921209)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2hfjRomInfo, Sf2hfjRomName, Sf2InputInfo, Sf2jDIPInfo,
	Sf2ceInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsSfzch = {
	"sfzch", NULL, NULL, "1995",
	"Street Fighter Zero (951020 CPS Changer)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 2, HARDWARE_CAPCOM_CPSCHANGER, GBF_VSFIGHT, FBF_SF,
	NULL, SfzchRomInfo, SfzchRomName, SfzchInputInfo, NULL,
	SfzchInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMbomberj = {
	"mbomberj", NULL, NULL, "1993",
	"Muscle Bomber: The Body Explosion (Japan 930713)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 4, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, MbomberjRomInfo, MbomberjRomName, SlammastInputInfo, SlammastDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsMbombrdj = {
	"mbombrdj", NULL, NULL, "1993",
	"Muscle Bomber Duo: Heat Up Warriors (Japan 931206)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING, 4, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, MbombrdjRomInfo, MbombrdjRomName, SlammastInputInfo, SlammastDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

struct BurnDriver BurnDrvCpsWofch = {
	"wofch", NULL, NULL, "1992",
	"Tenchi wo Kurau II - Sekiheki no Tatakai (921031 CPS Changer)\0", NULL, "Capcom", "CPS Changer",
	L"\u8EE2\u5730\u3092\u55B0\u3089\u3046II - \u8D64\u58C1\u306E\u6226\u3044 (Tenchi wo Kurau 2 921031 CPS Changer)\0Tenchi wo Kurau II - Sekiheki no Tatakai (921031 CPS Changer)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING, 3, HARDWARE_CAPCOM_CPSCHANGER, GBF_SCRFIGHT, 0,
	NULL, WofchRomInfo, WofchRomName, WofchInputInfo, NULL,
	WofchInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	JBF_GAME_WORKING, DrvJukeboxInit, DrvJukeboxExit, DrvJukeboxFrame, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};


// Saturday Night Slam Masters (Asia)
// Seems to be just a region hack

static struct BurnRomInfo SlammasaRomDesc[] = {
	{ "mba_23e.rom",   0x080000, 0x027e49db, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbe_24b.rom",   0x020000, 0x95d5e729, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_28b.rom",   0x020000, 0xb1c7cbcb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_25b.rom",   0x020000, 0xa50d3fd4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	
	{ "mbe_29b.rom",   0x020000, 0x08e32e56, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_21a.rom",   0x080000, 0xd5007b05, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbe_20a.rom",   0x080000, 0xaeb557b0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb_gfx01.rom",  0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb_gfx03.rom",  0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb_gfx02.rom",  0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb_gfx04.rom",  0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb_05.bin",     0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_07.bin",     0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_06.bin",     0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.bin",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.bin",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_12.bin",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_11.bin",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.bin",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_qa.rom",     0x020000, 0xe21a03c4, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb_q1.bin",     0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q2.bin",     0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q3.bin",     0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q4.bin",     0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q5.bin",     0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q6.bin",     0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q7.bin",     0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q8.bin",     0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Slammasa)
STD_ROM_FN(Slammasa)

struct BurnDriverX BurnDrvCpsSlammasa = {
	"slammasa", "slammast", NULL, "1993",
	"Saturday Night Slam Masters (Asia 930301)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 4, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, SlammasaRomInfo, SlammasaRomName, SlammastInputInfo, SlammastDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Saturday Night Slam Masters (Hispanic)
// Seems to be just a region hack
static struct BurnRomInfo SlammashRomDesc[] = {
	{ "mbh_23e.rom",   0x080000, 0xb0220f4a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbe_24b.rom",   0x020000, 0x95d5e729, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_28b.rom",   0x020000, 0xb1c7cbcb, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_25b.rom",   0x020000, 0xa50d3fd4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },	
	{ "mbe_29b.rom",   0x020000, 0x08e32e56, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbe_21a.rom",   0x080000, 0xd5007b05, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbe_20a.rom",   0x080000, 0xaeb557b0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb_gfx01.rom",  0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb_gfx03.rom",  0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb_gfx02.rom",  0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb_gfx04.rom",  0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb_05.bin",     0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_07.bin",     0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_06.bin",     0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.bin",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.bin",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_12.bin",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_11.bin",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.bin",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_qa.rom",     0x020000, 0xe21a03c4, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb_q1.bin",     0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q2.bin",     0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q3.bin",     0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q4.bin",     0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q5.bin",     0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q6.bin",     0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q7.bin",     0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q8.bin",     0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Slammash)
STD_ROM_FN(Slammash)

struct BurnDriverX BurnDrvCpsSlammash = {
	"slammash", "slammast", NULL, "1993",
	"Saturday Night Slam Masters (Slam Masters 930713 Hispanic)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 4, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, SlammashRomInfo, SlammashRomName, SlammastInputInfo, SlammastDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Muscle Bomber Duo (Japan E)
// Seems to be just a region hack
static struct BurnRomInfo MbombdjeRomDesc[] = {
	{ "mbd_26.bin",    0x020000, 0x72b7451c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdje_30.rom",  0x020000, 0x61b09fb1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_27.bin",    0x020000, 0x4086f534, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_31.bin",    0x020000, 0x085f47f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_24.bin",    0x020000, 0xc20895a5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_28.bin",    0x020000, 0x2618d5e1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_25.bin",    0x020000, 0x9bdb6b11, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_29.bin",    0x020000, 0x3f52d5e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_21.bin",    0x080000, 0x690c026a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbd_20.bin",    0x080000, 0xb8b2139b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb_gfx01.rom",  0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb_gfx03.rom",  0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb_gfx02.rom",  0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb_gfx04.rom",  0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb_05.bin",     0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_07.bin",     0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_06.bin",     0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.bin",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.bin",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_12.bin",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_11.bin",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.bin",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_q.bin",      0x020000, 0xd6fa76d1, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb_q1.bin",     0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q2.bin",     0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q3.bin",     0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q4.bin",     0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q5.bin",     0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q6.bin",     0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q7.bin",     0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q8.bin",     0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Mbombdje)
STD_ROM_FN(Mbombdje)

struct BurnDriverX BurnDrvCpsMbombdje = {
	"mbombdje", "mbombrd", NULL, "1993",
	"Muscle Bomber Duo - heat up warriors (931206 Japan E)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 4, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, MbombdjeRomInfo, MbombdjeRomName, SlammastInputInfo, SlammastDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Muscle Bomber Duo (Asia)
// Seems to be just a region hack
static struct BurnRomInfo MbombrdaRomDesc[] = {
	{ "mbd_26.bin",    0x020000, 0x72b7451c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbda_30.rom",   0x020000, 0x42eaa9da, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_27.bin",    0x020000, 0x4086f534, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_31.bin",    0x020000, 0x085f47f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_24.bin",    0x020000, 0xc20895a5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_28.bin",    0x020000, 0x2618d5e1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_25.bin",    0x020000, 0x9bdb6b11, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_29.bin",    0x020000, 0x3f52d5e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_21.bin",    0x080000, 0x690c026a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbd_20.bin",    0x080000, 0xb8b2139b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb_gfx01.rom",  0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb_gfx03.rom",  0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb_gfx02.rom",  0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb_gfx04.rom",  0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb_05.bin",     0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_07.bin",     0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_06.bin",     0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.bin",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.bin",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_12.bin",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_11.bin",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.bin",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_q.bin",      0x020000, 0xd6fa76d1, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb_q1.bin",     0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q2.bin",     0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q3.bin",     0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q4.bin",     0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q5.bin",     0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q6.bin",     0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q7.bin",     0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q8.bin",     0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Mbombrda)
STD_ROM_FN(Mbombrda)

struct BurnDriverX BurnDrvCpsMbombrda = {
	"mbombrda", "mbombrd", NULL, "1993",
	"Muscle Bomber Duo - ultimate team battle (Asia 931206)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 4, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, MbombrdaRomInfo, MbombrdaRomName, SlammastInputInfo, SlammastDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Muscle Bomber Duo (Hispanic)
// Seems to be just a region hack
static struct BurnRomInfo MbombrdhRomDesc[] = {
	{ "mbd_26.bin",    0x020000, 0x72b7451c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdh_30.rom",   0x020000, 0x836cea7d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_27.bin",    0x020000, 0x4086f534, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_31.bin",    0x020000, 0x085f47f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_24.bin",    0x020000, 0xc20895a5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_28.bin",    0x020000, 0x2618d5e1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_25.bin",    0x020000, 0x9bdb6b11, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_29.bin",    0x020000, 0x3f52d5e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_21.bin",    0x080000, 0x690c026a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbd_20.bin",    0x080000, 0xb8b2139b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb_gfx01.rom",  0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb_gfx03.rom",  0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb_gfx02.rom",  0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb_gfx04.rom",  0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb_05.bin",     0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_07.bin",     0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_06.bin",     0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.bin",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.bin",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_12.bin",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_11.bin",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.bin",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_q.bin",      0x020000, 0xd6fa76d1, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb_q1.bin",     0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q2.bin",     0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q3.bin",     0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q4.bin",     0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q5.bin",     0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q6.bin",     0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q7.bin",     0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q8.bin",     0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Mbombrdh)
STD_ROM_FN(Mbombrdh)

struct BurnDriverX BurnDrvCpsMbombrdh = {
	"mbombrdh", "mbombrd", NULL, "1993",
	"Muscle Bomber Duo - ultimate team battle (931206 Hispanic)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 4, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, MbombrdhRomInfo, MbombrdhRomName, SlammastInputInfo, SlammastDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Muscle Bomber Duo (USA)
// Seems to be just a region hack
static struct BurnRomInfo MbombrduRomDesc[] = {
	{ "mbd_26.bin",    0x020000, 0x72b7451c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbdu_30.rom",   0x020000, 0x5c234403, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_27.bin",    0x020000, 0x4086f534, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_31.bin",    0x020000, 0x085f47f0, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_24.bin",    0x020000, 0xc20895a5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_28.bin",    0x020000, 0x2618d5e1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_25.bin",    0x020000, 0x9bdb6b11, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_29.bin",    0x020000, 0x3f52d5e5, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "mbd_21.bin",    0x080000, 0x690c026a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "mbd_20.bin",    0x080000, 0xb8b2139b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "mb_gfx01.rom",  0x080000, 0x41468e06, BRF_GRA | CPS1_TILES },
	{ "mb_gfx03.rom",  0x080000, 0xf453aa9e, BRF_GRA | CPS1_TILES },
	{ "mb_gfx02.rom",  0x080000, 0x2ffbfea8, BRF_GRA | CPS1_TILES },
	{ "mb_gfx04.rom",  0x080000, 0x1eb9841d, BRF_GRA | CPS1_TILES },
	{ "mb_05.bin",     0x080000, 0x506b9dc9, BRF_GRA | CPS1_TILES },
	{ "mb_07.bin",     0x080000, 0xaff8c2fb, BRF_GRA | CPS1_TILES },
	{ "mb_06.bin",     0x080000, 0xb76c70e9, BRF_GRA | CPS1_TILES },
	{ "mb_08.bin",     0x080000, 0xe60c9556, BRF_GRA | CPS1_TILES },
	{ "mb_10.bin",     0x080000, 0x97976ff5, BRF_GRA | CPS1_TILES },
	{ "mb_12.bin",     0x080000, 0xb350a840, BRF_GRA | CPS1_TILES },
	{ "mb_11.bin",     0x080000, 0x8fb94743, BRF_GRA | CPS1_TILES },
	{ "mb_13.bin",     0x080000, 0xda810d5f, BRF_GRA | CPS1_TILES },

	{ "mb_q.bin",      0x020000, 0xd6fa76d1, BRF_ESS | BRF_PRG | CPS1_Z80_PROGRAM },

	{ "mb_q1.bin",     0x080000, 0x0630c3ce, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q2.bin",     0x080000, 0x354f9c21, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q3.bin",     0x080000, 0x7838487c, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q4.bin",     0x080000, 0xab66e087, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q5.bin",     0x080000, 0xc789fef2, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q6.bin",     0x080000, 0xecb81b61, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q7.bin",     0x080000, 0x041e49ba, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "mb_q8.bin",     0x080000, 0x59fe702a, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Mbombrdu)
STD_ROM_FN(Mbombrdu)

struct BurnDriverX BurnDrvCpsMbombrdu = {
	"mbombrdu", "mbombrd", NULL, "1993",
	"Muscle Bomber Duo - ultimate team battle (USA 931206)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 4, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, 0,
	NULL, MbombrduRomInfo, MbombrduRomName, SlammastInputInfo, SlammastDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

static struct BurnRomInfo Sf2cebrRomDesc[] = {
	{ "sf2cebr.23",    0x080000, 0x74e848ee, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },
	{ "sf2cebr.22",    0x080000, 0xc3c49626, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },
	{ "s92_21a.bin",   0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92br_10.bin",  0x080000, 0xb3e1dd5f, BRF_GRA | CPS1_TILES },
	{ "s92br_11.bin",  0x080000, 0xf13af812, BRF_GRA | CPS1_TILES },
	{ "s92br_12.bin",  0x080000, 0x10ce42af, BRF_GRA | CPS1_TILES },
	{ "s92br_13.bin",  0x080000, 0x32cf5af3, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2cebr)
STD_ROM_FN(Sf2cebr)

struct BurnDriverX BurnDrvCpsSf2cebr = {
	"sf2cebr", "sf2ce", NULL, "1992",
	"Street Fighter II': Champion Edition (Brazil, bootleg)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2cebrRomInfo, Sf2cebrRomName, Sf2InputInfo, Sf2DIPInfo,
	Sf2ceInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

static struct BurnRomInfo Sf2cehRomDesc[] = {
	{ "sf2ceh.23",     0x080000, 0x25dc14c8, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },
	{ "sf2ceh.22",     0x080000, 0x1c9dd91c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },
	{ "s92_21a.bin",   0x080000, 0x925a7877, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP  },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2ceh)
STD_ROM_FN(Sf2ceh)

struct BurnDriverX BurnDrvCpsSf2ceh = {
	"sf2ceh", "sf2ce", NULL, "1992",
	"Street Fighter II': Champion Edition (Hispanic, bootleg)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2cehRomInfo, Sf2cehRomName, Sf2InputInfo, Sf2DIPInfo,
	Sf2ceInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Warriors of Fate (French Translation)
// Very similar to wof
static struct BurnRomInfo WoffrRomDesc[] = {
	{ "tk2e_23bfr.rom",0x080000, 0xe006e81e, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "tk2e_22b.rom",  0x080000, 0x479b3f24, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "tk2_gfx1.rom",  0x080000, 0x0d9cb9bf, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx3.rom",  0x080000, 0x45227027, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx2.rom",  0x080000, 0xc5ca2460, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx4.rom",  0x080000, 0xe349551c, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx5fr.rom",0x080000, 0x1b6bc2b2, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx7fr.rom",0x080000, 0x3f1e5334, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx6fr.rom",0x080000, 0x28c9d96f, BRF_GRA | CPS1_TILES },
	{ "tk2_gfx8fr.rom",0x080000, 0xb3b9a29e, BRF_GRA | CPS1_TILES },

	{ "tk2_qa.rom",    0x020000, 0xc9183a0d, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "tk2_q1.rom",    0x080000, 0x611268cf, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q2.rom",    0x080000, 0x20f55ca9, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q3.rom",    0x080000, 0xbfcf6f52, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "tk2_q4.rom",    0x080000, 0x36642e88, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Woffr)
STD_ROM_FN(Woffr)

struct BurnDriverX BurnDrvCpsWoffr = {
	"woffr", "wof", NULL, "1992",
	"Warriors of Fate (French Translation)\0", NULL, "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, WoffrRomInfo, WoffrRomName, WofInputInfo, WofDIPInfo,
	TwelveMhzInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Street Fighter Alpha (CPS-Changer)
// Seems to be just a region hack
static struct BurnRomInfo SfachRomDesc[] = {
	{ "sfach23",       0x080000, 0x02a1a853, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza22",        0x080000, 0x8d9b2480, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfzch21",       0x080000, 0x5435225d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza20",        0x080000, 0x806e8f38, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sfz01",         0x080000, 0x0dd53e62, BRF_GRA | CPS1_TILES },
	{ "sfz02",         0x080000, 0x94c31e3f, BRF_GRA | CPS1_TILES },
	{ "sfz03",         0x080000, 0x9584ac85, BRF_GRA | CPS1_TILES },
	{ "sfz04",         0x080000, 0xb983624c, BRF_GRA | CPS1_TILES },
	{ "sfz05",         0x080000, 0x2b47b645, BRF_GRA | CPS1_TILES },
	{ "sfz06",         0x080000, 0x74fd9fb1, BRF_GRA | CPS1_TILES },
	{ "sfz07",         0x080000, 0xbb2c734d, BRF_GRA | CPS1_TILES },
	{ "sfz08",         0x080000, 0x454f7868, BRF_GRA | CPS1_TILES },
	{ "sfz10",         0x080000, 0x2a7d675e, BRF_GRA | CPS1_TILES },
	{ "sfz11",         0x080000, 0xe35546c8, BRF_GRA | CPS1_TILES },
	{ "sfz12",         0x080000, 0xf122693a, BRF_GRA | CPS1_TILES },
	{ "sfz13",         0x080000, 0x7cf942c8, BRF_GRA | CPS1_TILES },
	{ "sfz14",         0x080000, 0x09038c81, BRF_GRA | CPS1_TILES },
	{ "sfz15",         0x080000, 0x1aa17391, BRF_GRA | CPS1_TILES },
	{ "sfz16",         0x080000, 0x19a5abd6, BRF_GRA | CPS1_TILES },
	{ "sfz17",         0x080000, 0x248b3b73, BRF_GRA | CPS1_TILES },

	{ "sfz09",         0x010000, 0xc772628b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "sfz18",         0x020000, 0x61022b2d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sfz19",         0x020000, 0x3b5886d5, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sfach)
STD_ROM_FN(Sfach)

struct BurnDriverX BurnDrvCpsSfach = {
	"sfach", "sfzch", NULL, "1995",
	"Street Fighter Alpha (950727 CPS Changer)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 2, HARDWARE_CAPCOM_CPSCHANGER, GBF_VSFIGHT, FBF_SF,
	NULL, SfachRomInfo, SfachRomName, SfzchInputInfo, NULL,
	SfzchInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Street Fighter Zero Brazil (CPS-Changer)
// Seems to be just a region hack
static struct BurnRomInfo SfzbchRomDesc[] = {
	{ "sfbch23",       0x080000, 0x53699f68, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza22",        0x080000, 0x8d9b2480, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfzch21",       0x080000, 0x5435225d, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "sfza20",        0x080000, 0x806e8f38, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "sfz01",         0x080000, 0x0dd53e62, BRF_GRA | CPS1_TILES },
	{ "sfz02",         0x080000, 0x94c31e3f, BRF_GRA | CPS1_TILES },
	{ "sfz03",         0x080000, 0x9584ac85, BRF_GRA | CPS1_TILES },
	{ "sfz04",         0x080000, 0xb983624c, BRF_GRA | CPS1_TILES },
	{ "sfz05",         0x080000, 0x2b47b645, BRF_GRA | CPS1_TILES },
	{ "sfz06",         0x080000, 0x74fd9fb1, BRF_GRA | CPS1_TILES },
	{ "sfz07",         0x080000, 0xbb2c734d, BRF_GRA | CPS1_TILES },
	{ "sfz08",         0x080000, 0x454f7868, BRF_GRA | CPS1_TILES },
	{ "sfz10",         0x080000, 0x2a7d675e, BRF_GRA | CPS1_TILES },
	{ "sfz11",         0x080000, 0xe35546c8, BRF_GRA | CPS1_TILES },
	{ "sfz12",         0x080000, 0xf122693a, BRF_GRA | CPS1_TILES },
	{ "sfz13",         0x080000, 0x7cf942c8, BRF_GRA | CPS1_TILES },
	{ "sfz14",         0x080000, 0x09038c81, BRF_GRA | CPS1_TILES },
	{ "sfz15",         0x080000, 0x1aa17391, BRF_GRA | CPS1_TILES },
	{ "sfz16",         0x080000, 0x19a5abd6, BRF_GRA | CPS1_TILES },
	{ "sfz17",         0x080000, 0x248b3b73, BRF_GRA | CPS1_TILES },

	{ "sfz09",         0x010000, 0xc772628b, BRF_PRG | CPS1_Z80_PROGRAM },
	
	{ "sfz18",         0x020000, 0x61022b2d, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "sfz19",         0x020000, 0x3b5886d5, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sfzbch)
STD_ROM_FN(Sfzbch)

struct BurnDriverX BurnDrvCpsSfzbch = {
	"sfzbch", "sfzch", NULL, "1995",
	"Street Fighter Zero (950727 Brazil CPS Changer)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_HACK, 2, HARDWARE_CAPCOM_CPSCHANGER, GBF_VSFIGHT, FBF_SF,
	NULL, SfzbchRomInfo, SfzbchRomName, SfzchInputInfo, NULL,
	SfzchInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

#if defined INCLUDE_DUPLICATES

// Cadillacs and Dinosaurs (bootleg)
// this is the same as dinopic (once the pic program is added)
static struct BurnRomInfo DinobRomDesc[] = {
	{ "5.bin",         0x080000, 0x96dfcbf1, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "3.bin",         0x080000, 0x13dfeb08, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "7.bin",         0x080000, 0x6133f349, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "2.bin",         0x080000, 0x0e4058ba, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	
	{ "4.bin",         0x080000, 0xf3c2c98d, BRF_GRA | CPS1_TILES },
	{ "8.bin",         0x080000, 0xd574befc, BRF_GRA | CPS1_TILES },
	{ "9.bin",         0x080000, 0x55ef0adc, BRF_GRA | CPS1_TILES },
	{ "6.bin",         0x080000, 0xcc0805fc, BRF_GRA | CPS1_TILES },
	{ "13.bin",        0x080000, 0x1371f714, BRF_GRA | CPS1_TILES },
	{ "12.bin",        0x080000, 0xb284c4a7, BRF_GRA | CPS1_TILES },
	{ "11.bin",        0x080000, 0xb7ad3394, BRF_GRA | CPS1_TILES },
	{ "10.bin",        0x080000, 0x88847705, BRF_GRA | CPS1_TILES },
	
	{ "pic16c57-rp",   0x002d4c, 0x5a6d393c, BRF_PRG | CPS1_PIC },

	{ "1.bin",         0x080000, 0x7d921309, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Dinob)
STD_ROM_FN(Dinob)

struct BurnDriverX BurnDrvCpsDinob = {
	"dinob", "dino", NULL, "1993",
	"Cadillacs and Dinosaurs (identical to dinopic)\0", "Missing sprites, no sound", "Capcom", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_CLONE | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, DinobRomInfo, DinobRomName, DinoInputInfo, DinoDIPInfo,
	DinopicInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Cadillacs and Dinosaurs Turbo (Asia Bootleg)
// this is the same as dinoha
static struct BurnRomInfo Kl2dRomDesc[] = {
	{ "kl2-r1.800",    0x100000, 0x4c70dca7, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },
	{ "kl2-l2.800",    0x100000, 0xc6ae7338, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_NO_BYTESWAP },

	{ "cd-a.160",      0x200000, 0x7e4f9fb3, BRF_GRA | CPS1_TILES },
	{ "cd-b.160",      0x200000, 0x89532d85, BRF_GRA | CPS1_TILES },
	
	{ "cd_q.rom",      0x020000, 0x605fdb0b, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "cd_q1.rom",     0x080000, 0x60927775, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q2.rom",     0x080000, 0x770f4c47, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q3.rom",     0x080000, 0x2f273ffc, BRF_SND | CPS1_QSOUND_SAMPLES },
	{ "cd_q4.rom",     0x080000, 0x2c67821d, BRF_SND | CPS1_QSOUND_SAMPLES },
};

STD_ROM_PICK(Kl2d)
STD_ROM_FN(Kl2d)

struct BurnDriverX BurnDrvCpsKl2d = {
	"kl2d", "dino", NULL, "1993",
	"Cadillacs and Dinosaurs Turbo (identical to dinoha)\0", NULL, "bootleg", "CPS1 / QSound",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_BOOTLEG, 3, HARDWARE_CAPCOM_CPS1_QSOUND, GBF_SCRFIGHT, 0,
	NULL, Kl2dRomInfo, Kl2dRomName, DinoInputInfo, DinoDIPInfo,
	DinohaInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Street Fighter 2 Champion Edition (Slay the Dragon, bootleg)
// this is the same as sf2tlona
static struct BurnRomInfo Sf2tloncRomDesc[] = {
	{ "u222-f83.040",  0x100000, 0x47468198, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // first and second halves are identical
	{ "u196-99d.040",  0x100000, 0x47d34191, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // first and second halves are identical
	{ "u221-59e.010",  0x040000, 0x5507bac9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // first and second halves are identical
	{ "u195-472.010",  0x040000, 0x7755a20a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // first and second halves are identical

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2tlonc)
STD_ROM_FN(Sf2tlonc)

static int Sf2tloncInit()
{
	int nRet = 0;
	
	nRet = Sf2m4Init();
	
	memcpy(CpsRom + 0x100000, CpsRom + 0x200000, 0x80000);
        
	return nRet;
}

struct BurnDriverX BurnDrvCpsSf2tlonc = {
	"sf2tlonc", "sf2ce", NULL, "1992",
	"Street Fighter II': Champion Edition (identical to sf2tlona)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2tloncRomInfo, Sf2tloncRomName, Sf2yycInputInfo, Sf2DIPInfo,
	Sf2tloncInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Street Fighter 2 Champion Edition (turyu, bootleg)
// this is the same as sf2tlona
static struct BurnRomInfo Sf2turyuRomDesc[] = {
	{"u222-f83.040",  0x0100000, 0x47468198, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // first and second halves are identical
	{"u196-99d.040",  0x0100000, 0x47d34191, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // first and second halves are identical
	{"u221-59e.010",  0x0040000, 0x5507bac9, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // first and second halves are identical
	{"u195-472.010",  0x0040000, 0x7755a20a, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP }, // first and second halves are identical

	{ "s92_01.bin",   0x0080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",   0x0080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",   0x0080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",   0x0080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",   0x0080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",   0x0080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",   0x0080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",   0x0080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",   0x0080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",   0x0080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",   0x0080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",   0x0080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2turyu)
STD_ROM_FN(Sf2turyu)

struct BurnDriverX BurnDrvCpsSf2turyu = {
	"sf2turyu", "sf2ce", NULL, "1992",
	"Street Fighter II': Champion Edition (identical to sf2tlona)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2turyuRomInfo, Sf2turyuRomName, Sf2yycInputInfo, Sf2DIPInfo,
	Sf2tloncInit, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Street Fighter 2 Champion Edition (turyu set 2, bootleg)
// this is the same as sf2tlonb
static struct BurnRomInfo Sf2tury2RomDesc[] = {
	{ "tl4m.1",        0x080000, 0xafc7bd18, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "tl4m.2",        0x080000, 0x882cd1c4, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u221.1m",       0x020000, 0xd1707134, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },
	{ "u195.1m",       0x020000, 0xcd1d5666, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s92_10.bin",    0x080000, 0x960687d5, BRF_GRA | CPS1_TILES },
	{ "s92_11.bin",    0x080000, 0x978ecd18, BRF_GRA | CPS1_TILES },
	{ "s92_12.bin",    0x080000, 0xd6ec9a0a, BRF_GRA | CPS1_TILES },
	{ "s92_13.bin",    0x080000, 0xed2c67f6, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",    0x010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",    0x020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",    0x020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2tury2)
STD_ROM_FN(Sf2tury2)

struct BurnDriverX BurnDrvCpsSf2tury2 = {
	"sf2tury2", "sf2ce", NULL, "1992",
	"Street Fighter II': Champion Edition (identical to sf2tlonb)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2tury2RomInfo, Sf2tury2RomName, Sf2yycInputInfo, Sf2DIPInfo,
	Sf2m4Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

// Street Fighter 2 Champion Edition (ce13, bootleg)
// same as sf2m13
static struct BurnRomInfo Sf2ce13RomDesc[] = {
	{ "222-040.13",   0x0080000, 0xec6f5cb3, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP  },
	{ "196-040.13",   0x0080000, 0x0e9ac52b, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP  },
	{ "221-010.13",   0x0020000, 0x8226c11c, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP  },
	{ "195-010.13",   0x0020000, 0x924c6ce2, BRF_ESS | BRF_PRG | CPS1_68K_PROGRAM_BYTESWAP  },

	{ "s92_01.bin",    0x080000, 0x03b0d852, BRF_GRA | CPS1_TILES },
	{ "s92_02.bin",    0x080000, 0x840289ec, BRF_GRA | CPS1_TILES },
	{ "s92_03.bin",    0x080000, 0xcdb5f027, BRF_GRA | CPS1_TILES },
	{ "s92_04.bin",    0x080000, 0xe2799472, BRF_GRA | CPS1_TILES },
	{ "s92_05.bin",    0x080000, 0xba8a2761, BRF_GRA | CPS1_TILES },
	{ "s92_06.bin",    0x080000, 0xe584bfb5, BRF_GRA | CPS1_TILES },
	{ "s92_07.bin",    0x080000, 0x21e3f87d, BRF_GRA | CPS1_TILES },
	{ "s92_08.bin",    0x080000, 0xbefc47df, BRF_GRA | CPS1_TILES },
	{ "s2t_10.bin",    0x080000, 0x3c042686, BRF_GRA | CPS1_TILES },
	{ "s2t_11.bin",    0x080000, 0x8b7e7183, BRF_GRA | CPS1_TILES },
	{ "s2t_12.bin",    0x080000, 0x293c888c, BRF_GRA | CPS1_TILES },
	{ "s2t_13.bin",    0x080000, 0x842b35a4, BRF_GRA | CPS1_TILES },

	{ "s92_09.bin",   0x0010000, 0x08f6b60e, BRF_PRG | CPS1_Z80_PROGRAM },

	{ "s92_18.bin",   0x0020000, 0x7f162009, BRF_SND | CPS1_OKIM6295_SAMPLES },
	{ "s92_19.bin",   0x0020000, 0xbeade53f, BRF_SND | CPS1_OKIM6295_SAMPLES },
};

STD_ROM_PICK(Sf2ce13)
STD_ROM_FN(Sf2ce13)

struct BurnDriverX BurnDrvCpsSf2ce13 = {
	"sf2ce13", "sf2hf", NULL, "1992",
	"Street Fighter II': Champion Edition (identical to sf2m13)\0", NULL, "Capcom", "CPS Changer",
	NULL, NULL, NULL, NULL,
	BDF_CLONE | BDF_BOOTLEG, 2, HARDWARE_CAPCOM_CPS1, GBF_VSFIGHT, FBF_SF,
	NULL, Sf2ce13RomInfo, Sf2ce13RomName, Sf2yycInputInfo, Sf2DIPInfo,
	Sf2m13Init, DrvExit, Cps1Frame, CpsRedraw, CpsAreaScan,
	0, NULL, NULL, NULL, &CpsRecalcPal, 0x1000, 384, 224, 4, 3
};

#endif

#if defined INCLUDE_CPS1_PHOENIX

#endif

#undef INCLUDE_DUPLICATES
#undef INCLUDE_CPS1_PHOENIX

#undef CPS1_68K_PROGRAM_BYTESWAP
#undef CPS1_68K_PROGRAM_NO_BYTESWAP
#undef CPS1_Z80_PROGRAM
#undef CPS1_TILES
#undef CPS1_OKIM6295_SAMPLES
#undef CPS1_QSOUND_SAMPLES
#undef CPS1_PIC
